<?php
// Enable error reporting for debugging (remove in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Set Arabic language headers
header('Content-Type: text/html; charset=utf-8');

// Include database connection
require_once 'db.php';

// API endpoint (replace with your actual API URL)
$apiUrl = 'http://62.164.219.146:8000/api/v2/image/validate';
$apiKey = '9tZwimURlQMdn8VaI2IAGSFQ4fgbJVd9'; // Replace with your actual API key

// hCaptcha Configuration
$hcaptchaSecret = 'ES_044e9c8acdab4dbcaadc0c43350de0db';
$hcaptchaSiteKey = '5fe6e70c-a530-4240-99a2-0c8ca8e0be96';

$apiResponse = null;
$error = null;
$success = null;
$imagePreview = null;
$studentNumber = '';
$studentName = '';
$paymentVerified = false;
$validationResults = [];
$allValid = false;
$showValidationResults = false;

// Translation arrays
$validationLabels = [
    'faceDetected' => 'اكتشاف الوجه',
    'faceCentered' => 'الوجه في المنتصف',
    'appropriateHeadSize' => 'حجم الرأس مناسب',
    'whiteBackground' => 'خلفية بيضاء',
    'imageQuality' => 'جودة الصورة',
    'noGlasses' => 'بدون نظارات',
    'neutralExpression' => 'تعبير محايد',
    'eyesOpen' => 'العينان مفتوحتان',
    'goodLighting' => 'إضاءة جيدة',
    'noHeadwear' => 'بدون غطاء رأس'
];

$validationDescriptions = [
    'faceDetected' => 'تم اكتشاف وجه واضح في الصورة',
    'faceCentered' => 'الوجه موجود في منتصف الصورة بشكل مناسب',
    'appropriateHeadSize' => 'حجم الرأس يشغل النسبة الصحيحة من الصورة',
    'whiteBackground' => 'الخلفية بيضاء نقية ومناسبة',
    'imageQuality' => 'الصورة واضحة وحادة بدون تشويش',
    'noGlasses' => 'الوجه يظهر بدون نظارات',
    'neutralExpression' => 'التعبير الوجهي محايد وطبيعي',
    'eyesOpen' => 'العينان مفتوحتان وواضحتان',
    'goodLighting' => 'الإضاءة موزعة بشكل متساوي على الوجه',
    'noHeadwear' => 'الوجه يظهر بدون أي غطاء للرأس'
];

// Check if form was submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($apiKey)) {
    // Get student number
    $studentNumber = trim($_POST['student_number'] ?? '');
    
    // Validate student number
    if (empty($studentNumber)) {
        $error = "الرجاء إدخال رقم الطالب.";
    } else {
        // Check if student has paid - select top 1
        $stmt = $mysqli1->prepare("SELECT student_name FROM payments WHERE student_id = ? LIMIT 1");
        if ($stmt) {
            $stmt->bind_param("s", $studentNumber);
            $stmt->execute();
            $stmt->store_result();
            
            if ($stmt->num_rows > 0) {
                $stmt->bind_result($studentName);
                $stmt->fetch();
                $paymentVerified = true;
            } else {
                $error = "❌ لم يتم العثور على دفعة لهذا الرقم. الرجاء التحقق من رقم الطالب أو دفع الرسوم أولاً.";
                $paymentVerified = false;
            }
            $stmt->close();
        } else {
            $error = "خطأ في التحقق من قاعدة البيانات.";
            $paymentVerified = false;
        }
        
        // Only proceed if payment is verified
        if ($paymentVerified) {
            // Validate hCaptcha
            $hcaptchaResponse = $_POST['h-captcha-response'] ?? '';
            if (empty($hcaptchaResponse)) {
                $error = "الرجاء إكمال التحقق من أنك لست روبوتًا.";
            } else {
                // Verify hCaptcha response
                $isCaptchaValid = false;
                
                $verifyData = [
                    'secret' => $hcaptchaSecret,
                    'response' => $hcaptchaResponse,
                    'remoteip' => $_SERVER['REMOTE_ADDR']
                ];
                
                $ch = curl_init('https://hcaptcha.com/siteverify');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($verifyData));
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'Content-Type: application/x-www-form-urlencoded'
                ]);
                
                $verifyResponse = curl_exec($ch);
                $verifyResult = json_decode($verifyResponse, true);
                $isCaptchaValid = $verifyResult['success'] ?? false;
                
                if (!$isCaptchaValid) {
                    $error = "فشل التحقق من أنك لست روبوتًا. الرجاء المحاولة مرة أخرى.";
                    if (isset($verifyResult['error-codes'])) {
                        error_log("hCaptcha Error: " . implode(', ', $verifyResult['error-codes']));
                    }
                } else {
                    // Check if file was uploaded without errors
                    if (isset($_FILES['photo']) && $_FILES['photo']['error'] === UPLOAD_ERR_OK) {
                        // Validate file type
                        $allowedTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
                        $fileType = mime_content_type($_FILES['photo']['tmp_name']);
                        
                        if (!in_array($fileType, $allowedTypes)) {
                            $error = "نوع الملف غير صالح. يُسمح فقط بصور JPEG و PNG و GIF و WebP.";
                        } else {
                            // Validate file size (max 5MB)
                            $maxFileSize = 5 * 1024 * 1024; // 5MB
                            if ($_FILES['photo']['size'] > $maxFileSize) {
                                $error = "الملف كبير جدًا. الحد الأقصى للحجم هو 5 ميجابايت.";
                            } else {
                                // Read and convert file to base64
                                $imageData = file_get_contents($_FILES['photo']['tmp_name']);
                                $base64Image = base64_encode($imageData);
                                
                                // Prepare for image preview
                                $imagePreview = 'data:' . $fileType . ';base64,' . base64_encode($imageData);
                                
                                // Prepare the JSON data for API
                                $jsonData = json_encode([
                                    'image_base64' => $base64Image
                                ]);
                                
                                // Initialize cURL session
                                $ch = curl_init($apiUrl);
                                
                                // Set cURL options with X-API-Key header
                                $headers = [
                                    'Content-Type: application/json',
                                    'Content-Length: ' . strlen($jsonData),
                                    'X-API-Key: ' . $apiKey
                                ];
                                
                                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                                curl_setopt($ch, CURLOPT_POST, true);
                                curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
                                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                                curl_setopt($ch, CURLOPT_TIMEOUT, 30);
                                
                                // Execute the request
                                $response = curl_exec($ch);
                                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                                
                                // Check for cURL errors
                                if (curl_errno($ch)) {
                                    $error = 'خطأ في الاتصال بالخادم: ' . curl_error($ch);
                                } else {
                                    // Check HTTP status code
                                    if ($httpCode === 401) {
                                        $error = 'فشل المصادقة: مفتاح API غير صالح';
                                    } elseif ($httpCode === 403) {
                                        $error = 'محظور الوصول: مفتاح API لا يملك الصلاحية';
                                    } elseif ($httpCode >= 200 && $httpCode < 300) {
                                        // Parse JSON response
                                        $apiResponse = json_decode($response, true);
                                        
                                        // Check if JSON parsing was successful
                                        if (json_last_error() !== JSON_ERROR_NONE) {
                                            $error = 'رد غير صالح من الخادم: ' . json_last_error_msg();
                                            $apiResponse = null;
                                        } else {
                                            // Extract validation results from response
                                            if (isset($apiResponse['validation'])) {
                                                $validationResults = $apiResponse['validation'];
                                            } elseif (isset($apiResponse['faceDetected']) || isset($apiResponse['face_detected'])) {
                                                // Extract individual validation fields
                                                $validationFields = [
                                                    'faceDetected', 'face_detected',
                                                    'faceCentered', 'face_centered',
                                                    'appropriateHeadSize', 'appropriate_head_size',
                                                    'whiteBackground', 'white_background'
                                                ];
                                                
                                                foreach ($validationFields as $field) {
                                                    if (isset($apiResponse[$field])) {
                                                        $normalizedField = str_replace('_', '', lcfirst(ucwords($field, '_')));
                                                        $validationResults[$normalizedField] = $apiResponse[$field];
                                                    }
                                                }
                                            }
                                            
                                            // Check if all validations are true
                                            $allValid = true;
                                            foreach ($validationResults as $value) {
                                                if ($value !== true) {
                                                    $allValid = false;
                                                    break;
                                                }
                                            }
                                            
                                            $showValidationResults = true;
                                            
                                            // Only save the image if ALL validations pass
                                            if ($allValid && !empty($validationResults)) {
                                                // Create uploads directory if it doesn't exist
                                                $uploadDir = 'uploads/';
                                                if (!is_dir($uploadDir)) {
                                                    mkdir($uploadDir, 0755, true);
                                                }
                                                
                                                // Determine file extension based on MIME type
                                                $extensions = [
                                                    'image/jpeg' => 'jpg',
                                                    'image/png' => 'png',
                                                    'image/gif' => 'gif',
                                                    'image/webp' => 'webp'
                                                ];
                                                
                                                $extension = $extensions[$fileType] ?? 'jpg';
                                                $filename = $studentNumber . '.' . $extension;
                                                $filepath = $uploadDir . $filename;
                                                
                                                // Check if file already exists and create unique name if needed
                                                $counter = 1;
                                                while (file_exists($filepath)) {
                                                    $filename = $studentNumber . '_' . $counter . '.' . $extension;
                                                    $filepath = $uploadDir . $filename;
                                                    $counter++;
                                                }
                                                
                                                // Save the original uploaded file
                                                if (move_uploaded_file($_FILES['photo']['tmp_name'], $filepath)) {
                                                    $success = "✅ تم حفظ الصورة بنجاح باسم: " . htmlspecialchars($filename);
                                                } else {
                                                    $error = "❌ فشل حفظ الصورة على القرص.";
                                                }
                                            } elseif (empty($validationResults)) {
                                                $error = "❌ لم يتم استلام نتائج التحقق من الخادم.";
                                            }
                                        }
                                    } else {
                                        $error = "❌ فشل طلب API برمز HTTP: $httpCode";
                                    }
                                }
                                
                                // Close cURL session
                                curl_close($ch);
                            }
                        }
                    } else {
                        // Handle upload errors in Arabic
                        $uploadError = $_FILES['photo']['error'] ?? null;
                        switch ($uploadError) {
                            case UPLOAD_ERR_INI_SIZE:
                            case UPLOAD_ERR_FORM_SIZE:
                                $error = "الملف كبير جدًا.";
                                break;
                            case UPLOAD_ERR_PARTIAL:
                                $error = "تم رفع الملف جزئيًا فقط.";
                                break;
                            case UPLOAD_ERR_NO_FILE:
                                $error = "لم يتم رفع أي ملف.";
                                break;
                            case UPLOAD_ERR_NO_TMP_DIR:
                                $error = "مجلد مؤقت مفقود.";
                                break;
                            case UPLOAD_ERR_CANT_WRITE:
                                $error = "فشل كتابة الملف على القرص.";
                                break;
                            case UPLOAD_ERR_EXTENSION:
                                $error = "توقف رفع الملف بواسطة الامتداد.";
                                break;
                            default:
                                $error = "خطأ غير معروف في الرفع.";
                                break;
                        }
                    }
                }
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نظام رفع صور الطلاب</title>
    <!-- Arabic font -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- hCaptcha Script -->
    <script src="https://js.hcaptcha.com/1/api.js" async defer></script>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body {
            font-family: 'Cairo', sans-serif;
            line-height: 1.8;
            color: #333;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            padding: 20px;
            text-align: right;
            background-attachment: fixed;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        
        .header {
            background: linear-gradient(135deg, #1a642b 0%, #2c3e50 100%);
            color: white;
            padding: 40px 20px;
            text-align: center;
        }
        
        .header h1 {
            font-size: 2.5rem;
            margin-bottom: 15px;
        }
        
        .header h1 i {
            color: #f9dd10;
            margin-left: 15px;
        }
        
        .header p {
            opacity: 0.9;
            font-size: 1.1rem;
        }
        
        .content {
            padding: 30px;
        }
        
        /* Main Form Layout */
        .form-container {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
            margin-bottom: 30px;
        }
        
        @media (max-width: 768px) {
            .form-container {
                grid-template-columns: 1fr;
            }
        }
        
        /* Left Column - Form */
        .form-column {
            display: flex;
            flex-direction: column;
        }
        
        /* Right Column - Image Preview */
        .preview-column {
            display: flex;
            flex-direction: column;
        }
        
        /* Payment Status */
        .payment-status {
            background: #e8f5e9;
            border: 2px solid #4caf50;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            text-align: center;
            grid-column: 1 / -1;
        }
        
        .payment-status.invalid {
            background: #ffebee;
            border-color: #f44336;
        }
        
        .payment-icon {
            font-size: 3rem;
            margin-bottom: 15px;
        }
        
        .payment-title {
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 10px;
        }
        
        .student-info {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin: 20px 0;
            flex-wrap: wrap;
        }
        
        .info-item {
            background: white;
            padding: 15px;
            border-radius: 8px;
            border: 1px solid #ddd;
            min-width: 200px;
        }
        
        .info-label {
            font-size: 0.9rem;
            color: #666;
            margin-bottom: 5px;
        }
        
        .info-value {
            font-size: 1.2rem;
            font-weight: 700;
            color: #1a642b;
        }
        
        /* Upload Form */
        .upload-form {
            flex: 1;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 10px;
            font-weight: 600;
            color: #1a642b;
            font-size: 1.1rem;
        }
        
        .form-group input[type="text"] {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #ddd;
            border-radius: 8px;
            font-size: 1rem;
            font-family: 'Cairo', sans-serif;
            transition: all 0.3s ease;
        }
        
        .form-group input[type="text"]:focus {
            outline: none;
            border-color: #1a642b;
            box-shadow: 0 0 0 3px rgba(26, 100, 43, 0.1);
        }
        
        /* File Input */
        .file-input-wrapper {
            position: relative;
            margin: 20px 0;
        }
        
        .file-input {
            width: 100%;
            padding: 20px;
            border: 2px dashed #1a642b;
            border-radius: 10px;
            background: rgba(26, 100, 43, 0.05);
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            font-family: 'Cairo', sans-serif;
            font-size: 1rem;
        }
        
        .file-input:hover {
            border-color: #f9dd10;
            background: rgba(249, 221, 16, 0.1);
        }
        
        /* Image Preview Box */
        .preview-box {
            background: #f8f9fa;
            border: 2px dashed #6c757d;
            border-radius: 10px;
            padding: 20px;
            text-align: center;
            height: 100%;
            min-height: 400px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            transition: all 0.3s ease;
            position: relative;
        }
        
        .preview-box.has-image {
            border-color: #1a642b;
            background: white;
            border-style: solid;
        }
        
        .preview-placeholder {
            color: #6c757d;
            padding: 20px;
        }
        
        .preview-placeholder i {
            font-size: 4rem;
            margin-bottom: 20px;
            color: #adb5bd;
        }
        
        .preview-placeholder h3 {
            font-size: 1.5rem;
            margin-bottom: 10px;
            color: #495057;
        }
        
        .preview-placeholder p {
            color: #6c757d;
            font-size: 0.9rem;
        }
        
        .image-preview {
            max-width: 100%;
            max-height: 350px;
            border-radius: 8px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            border: 3px solid #1a642b;
            display: none;
        }
        
        .image-preview.show {
            display: block;
            animation: fadeIn 0.5s ease;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: scale(0.95); }
            to { opacity: 1; transform: scale(1); }
        }
        
        .image-info {
            margin-top: 20px;
            text-align: center;
            width: 100%;
        }
        
        .image-info-item {
            background: #e8f5e9;
            padding: 10px 15px;
            border-radius: 6px;
            margin: 5px 0;
            display: inline-block;
            font-size: 0.9rem;
            color: #1a642b;
            font-weight: 600;
        }
        
        /* hCaptcha */
        .hcaptcha-container {
            background: rgba(249, 221, 16, 0.1);
            padding: 20px;
            border-radius: 10px;
            border: 2px solid #f9dd10;
            margin: 20px 0;
            text-align: center;
            grid-column: 1 / -1;
        }
        
        .hcaptcha-instruction {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            margin-bottom: 15px;
            color: #333;
            font-size: 1.1rem;
        }
        
        .h-captcha {
            display: flex;
            justify-content: center;
            margin: 15px 0;
        }
        
        .hcaptcha-info {
            color: #666;
            font-size: 0.9rem;
            margin-top: 15px;
        }
        
        /* Submit Button */
        .submit-btn {
            background: linear-gradient(135deg, #1a642b 0%, #2c3e50 100%);
            color: white;
            border: none;
            padding: 15px 40px;
            font-size: 1.1rem;
            border-radius: 50px;
            cursor: pointer;
            transition: all 0.3s ease;
            display: block;
            margin: 30px auto 0;
            font-family: 'Cairo', sans-serif;
            font-weight: 600;
            width: 100%;
            max-width: 300px;
        }
        
        .submit-btn:hover:not(:disabled) {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(26, 100, 43, 0.2);
        }
        
        .submit-btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }
        
        /* Error/Success Messages */
        .error {
            background: #ffebee;
            border-right: 4px solid #f44336;
            padding: 20px;
            margin: 20px 0;
            border-radius: 10px;
            text-align: right;
            font-size: 1rem;
        }
        
        .success {
            background: #e8f5e9;
            border-right: 4px solid #4caf50;
            padding: 20px;
            margin: 20px 0;
            border-radius: 10px;
            text-align: right;
            font-size: 1rem;
        }
        
        /* Validation Results Section */
        .validation-results {
            margin-top: 30px;
            padding: 25px;
            background: #f8f9fa;
            border-radius: 15px;
            border: 2px solid #dee2e6;
            grid-column: 1 / -1;
            display: <?php echo $showValidationResults ? 'block' : 'none'; ?>;
        }
        
        .validation-header {
            text-align: center;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 2px solid #6c757d;
        }
        
        .validation-header h3 {
            font-size: 1.8rem;
            color: #1a642b;
            margin-bottom: 10px;
        }
        
        .validation-status {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
            margin-bottom: 20px;
            padding: 15px;
            border-radius: 10px;
            font-size: 1.2rem;
            font-weight: 600;
        }
        
        .validation-status.success {
            background: #e8f5e9;
            color: #1a642b;
            border: 2px solid #4caf50;
        }
        
        .validation-status.error {
            background: #ffebee;
            color: #f44336;
            border: 2px solid #f44336;
        }
        
        .validation-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin: 25px 0;
        }
        
        .validation-item {
            background: white;
            padding: 20px;
            border-radius: 10px;
            border: 2px solid #ddd;
            display: flex;
            align-items: center;
            gap: 15px;
            transition: all 0.3s ease;
        }
        
        .validation-item.valid {
            border-color: #4caf50;
            background: rgba(76, 175, 80, 0.05);
        }
        
        .validation-item.invalid {
            border-color: #f44336;
            background: rgba(244, 67, 54, 0.05);
        }
        
        .validation-icon {
            font-size: 1.8rem;
            width: 50px;
            height: 50px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            flex-shrink: 0;
        }
        
        .validation-item.valid .validation-icon {
            background: #4caf50;
            color: white;
        }
        
        .validation-item.invalid .validation-icon {
            background: #f44336;
            color: white;
        }
        
        .validation-details {
            flex: 1;
        }
        
        .validation-title {
            font-weight: 700;
            font-size: 1.1rem;
            margin-bottom: 5px;
            color: #333;
        }
        
        .validation-description {
            color: #666;
            font-size: 0.9rem;
        }
        
        /* Requirements Section */
        .requirements-box {
            background: #fff8e1;
            border: 2px solid #ffc107;
            border-radius: 10px;
            padding: 25px;
            margin: 25px 0;
            grid-column: 1 / -1;
        }
        
        .requirements-box h4 {
            color: #ff9800;
            font-size: 1.4rem;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .requirements-list {
            margin-right: 20px;
        }
        
        .requirements-list li {
            margin-bottom: 12px;
            padding-right: 10px;
            color: #5a6268;
            line-height: 1.6;
        }
        
        /* Action Buttons */
        .action-buttons {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 2px solid #dee2e6;
            grid-column: 1 / -1;
        }
        
        .action-btn {
            padding: 15px 30px;
            border-radius: 10px;
            font-size: 1.1rem;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            transition: all 0.3s ease;
            cursor: pointer;
            border: 2px solid;
        }
        
        .reset-btn {
            background: #ffc107;
            color: #333;
            border-color: #ff9800;
        }
        
        .reset-btn:hover {
            background: #ff9800;
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(255, 152, 0, 0.2);
        }
        
        .upload-new-btn {
            background: #1a642b;
            color: white;
            border-color: #1a642b;
        }
        
        .upload-new-btn:hover {
            background: #2c3e50;
            border-color: #2c3e50;
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(26, 100, 43, 0.2);
        }
        
        /* Payment Required */
        .payment-required {
            text-align: center;
            padding: 40px 20px;
            background: #fff8e1;
            border-radius: 10px;
            margin: 20px 0;
            border: 2px solid #ffc107;
            grid-column: 1 / -1;
        }
        
        .payment-required-icon {
            font-size: 3rem;
            color: #ff9800;
            margin-bottom: 20px;
        }
        
        .payment-required h3 {
            color: #ff9800;
            font-size: 1.8rem;
            margin-bottom: 15px;
        }
        
        .payment-required p {
            color: #666;
            font-size: 1.1rem;
            margin-bottom: 25px;
            max-width: 500px;
            margin-left: auto;
            margin-right: auto;
        }
        
        .payment-required-actions {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin-top: 20px;
            flex-wrap: wrap;
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .container {
                margin: 10px;
                border-radius: 10px;
            }
            
            .content {
                padding: 20px;
            }
            
            .header h1 {
                font-size: 2rem;
            }
            
            .header p {
                font-size: 1rem;
            }
            
            .student-info {
                flex-direction: column;
                gap: 10px;
            }
            
            .info-item {
                min-width: 100%;
            }
            
            .validation-grid {
                grid-template-columns: 1fr;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .action-btn {
                width: 100%;
                justify-content: center;
            }
            
            .payment-required-actions {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><i class="fas fa-graduation-cap"></i> نظام رفع صور الطلاب</h1>
            <p>رفع صور الطلاب مع التحقق الآلي والتسمية التلقائية</p>
        </div>
        
        <div class="content">
            <!-- System Status -->
            <?php if (empty($apiKey)): ?>
                <div class="error">
                    <strong>⚠️ خطأ في إعداد النظام</strong>
                    <p>مفتاح API غير مضبوط. يرجى الاتصال بالمسؤول.</p>
                </div>
            <?php endif; ?>
            
            <!-- Payment Verification Section -->
            <?php if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($studentNumber)): ?>
                <div class="payment-status <?php echo !$paymentVerified ? 'invalid' : ''; ?>">
                    <div class="payment-icon">
                        <?php if ($paymentVerified): ?>
                            <i class="fas fa-check-circle"></i>
                        <?php else: ?>
                            <i class="fas fa-times-circle"></i>
                        <?php endif; ?>
                    </div>
                    
                    <div class="payment-title">
                        <?php if ($paymentVerified): ?>
                            ✅ تم التحقق من الدفعة بنجاح
                        <?php else: ?>
                            ❌ لم يتم العثور على دفعة
                        <?php endif; ?>
                    </div>
                    
                    <div class="student-info">
                        <div class="info-item">
                            <div class="info-label">رقم الطالب</div>
                            <div class="info-value"><?php echo htmlspecialchars($studentNumber); ?></div>
                        </div>
                        
                        <?php if ($paymentVerified && !empty($studentName)): ?>
                        <div class="info-item">
                            <div class="info-label">اسم الطالب</div>
                            <div class="info-value"><?php echo htmlspecialchars($studentName); ?></div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
            
            <!-- Payment Required Message -->
            <?php if ($_SERVER['REQUEST_METHOD'] === 'POST' && !$paymentVerified): ?>
                <div class="payment-required">
                    <div class="payment-required-icon">
                        <i class="fas fa-lock"></i>
                    </div>
                    <h3>الوصول مقيد</h3>
                    <p>
                        لا يمكنك رفع الصورة لأنك لم تدفع الرسوم المطلوبة بعد.
                        الرجاء إكمال عملية الدفع أولاً، ثم حاول مرة أخرى.
                    </p>
                    
                    <div class="payment-required-actions">
                        <button onclick="window.location.reload()" class="action-btn reset-btn">
                            <i class="fas fa-redo"></i> إعادة المحاولة
                        </button>
                    </div>
                </div>
            <?php endif; ?>
            
            <!-- Main Form and Preview -->
            <?php if (!$showValidationResults || !$allValid): ?>
                <div class="form-container">
                    <!-- Left Column - Form -->
                    <div class="form-column">
                        <form method="POST" enctype="multipart/form-data" class="upload-form" id="uploadForm">
                            <div class="form-group">
                                <label for="student_number"><i class="fas fa-id-card"></i> رقم الطالب *</label>
                                <input type="text" 
                                       id="student_number" 
                                       name="student_number" 
                                       value="<?php echo htmlspecialchars($studentNumber); ?>"
                                       placeholder="أدخل رقم الطالب"
                                       required
                                       <?php echo empty($apiKey) ? 'disabled' : ''; ?>>
                            </div>
                            
                            <?php if ($paymentVerified || $_SERVER['REQUEST_METHOD'] !== 'POST'): ?>
                                <div class="form-group">
                                    <label for="photo"><i class="fas fa-camera"></i> صورة الطالب *</label>
                                    <div class="file-input-wrapper">
                                        <input type="file" 
                                               name="photo" 
                                               id="photo" 
                                               accept="image/*" 
                                               required 
                                               class="file-input"
                                               onchange="previewImage(this)"
                                               <?php echo empty($apiKey) ? 'disabled' : ''; ?>>
                                    </div>
                                </div>
                                
                                <!-- hCaptcha Section -->
                                <div class="hcaptcha-container">
                                    <div class="hcaptcha-instruction">
                                        <i class="fas fa-robot"></i>
                                        <span>الرجاء التحقق من أنك لست روبوتًا</span>
                                    </div>
                                    
                                    <div class="h-captcha" 
                                         data-sitekey="5fe6e70c-a530-4240-99a2-0c8ca8e0be96"
                                         data-theme="light"
                                         data-size="normal"
                                         data-callback="onCaptchaSuccess"
                                         data-expired-callback="onCaptchaExpired">
                                    </div>
                                    
                                    <div class="hcaptcha-info">
                                        <i class="fas fa-info-circle"></i>
                                        هذا التحقق يضمن أمان النظام ويمنع الاستخدام الآلي
                                    </div>
                                </div>
                                
                                <button type="submit" 
                                        class="submit-btn" 
                                        id="submitBtn"
                                        disabled>
                                    <span id="submitText">
                                        <?php echo empty($apiKey) ? '⚠️ النظام غير متاح' : '<i class="fas fa-upload"></i> رفع وتحقق من الصورة'; ?>
                                    </span>
                                </button>
                            <?php endif; ?>
                        </form>
                    </div>
                    
                    <!-- Right Column - Image Preview -->
                    <div class="preview-column">
                        <div class="preview-box" id="previewBox">
                            <div class="preview-placeholder" id="previewPlaceholder">
                                <i class="fas fa-image"></i>
                                <h3>معاينة الصورة</h3>
                                <p>سيظهر هنا معاينة للصورة بعد اختيارها</p>
                            </div>
                            <img src="" alt="معاينة الصورة" class="image-preview" id="imagePreview">
                            <div class="image-info" id="imageInfo"></div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            
            <!-- Success Message -->
            <?php if ($success): ?>
                <div class="success">
                    <div style="display: flex; align-items: center; gap: 15px;">
                        <span style="font-size: 2rem; color: #4caf50;">✅</span>
                        <div>
                            <h4 style="margin: 0 0 10px 0; color: #4caf50;">تم بنجاح!</h4>
                            <p style="margin: 0;"><?php echo htmlspecialchars($success); ?></p>
                        </div>
                    </div>
                    <div class="action-buttons">
                        <button onclick="window.location.reload()" class="action-btn upload-new-btn">
                            <i class="fas fa-plus"></i> رفع صورة جديدة
                        </button>
                    </div>
                </div>
            <?php endif; ?>
            
            <!-- Error Display -->
            <?php if ($error && $paymentVerified && !$showValidationResults): ?>
                <div class="error">
                    <div style="display: flex; align-items: center; gap: 15px;">
                        <span style="font-size: 2rem; color: #f44336;">❌</span>
                        <div>
                            <h4 style="margin: 0 0 10px 0; color: #f44336;">خطأ</h4>
                            <p style="margin: 0;"><?php echo htmlspecialchars($error); ?></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            
            <!-- Validation Results -->
            <?php if ($showValidationResults && !empty($validationResults)): 
                $validCount = 0;
                $totalCount = count($validationResults);
                
                foreach ($validationResults as $value) {
                    if ($value === true) {
                        $validCount++;
                    }
                }
                
                $successPercentage = $totalCount > 0 ? round(($validCount / $totalCount) * 100) : 0;
            ?>
                <div class="validation-results" id="validationResults">
                    <div class="validation-header">
                        <h3><i class="fas fa-clipboard-check"></i> نتائج التحقق</h3>
                        <div class="validation-status <?php echo $allValid ? 'success' : 'error'; ?>">
                            <?php if ($allValid): ?>
                                <i class="fas fa-check-circle"></i>
                                <span>✅ تم التحقق بنجاح - جميع المعايير مطابقة</span>
                            <?php else: ?>
                                <i class="fas fa-exclamation-circle"></i>
                                <span>⚠️ الصورة غير مطابقة للمعايير - النسبة: <?php echo $successPercentage; ?>%</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Validation Details -->
                    <div class="validation-grid">
                        <?php foreach ($validationResults as $key => $value): 
                            $isValid = $value === true;
                            $arabicLabel = $validationLabels[$key] ?? $key;
                            $arabicDescription = $validationDescriptions[$key] ?? 'معيار التحقق';
                        ?>
                            <div class="validation-item <?php echo $isValid ? 'valid' : 'invalid'; ?>">
                                <div class="validation-icon">
                                    <?php if ($isValid): ?>
                                        <i class="fas fa-check"></i>
                                    <?php else: ?>
                                        <i class="fas fa-times"></i>
                                    <?php endif; ?>
                                </div>
                                <div class="validation-details">
                                    <div class="validation-title"><?php echo htmlspecialchars($arabicLabel); ?></div>
                                    <div class="validation-description"><?php echo htmlspecialchars($arabicDescription); ?></div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    
                    <?php if (!$allValid): ?>
                        <!-- Requirements Section -->
                        <div class="requirements-box">
                            <h4><i class="fas fa-exclamation-triangle"></i> متطلبات الصورة الشخصية</h4>
                            <ul class="requirements-list">
                                <li><strong>وجه واضح:</strong> يجب أن يظهر الوجه بوضوح في الصورة</li>
                                <li><strong>مركزية:</strong> الوجه يجب أن يكون في منتصف الصورة</li>
                                <li><strong>حجم مناسب:</strong> حجم الرأس يجب أن يشغل حوالي 60-70% من الصورة</li>
                                <li><strong>خلفية بيضاء:</strong> يجب أن تكون الخلفية بيضاء نقية بدون أنماط</li>
                                <li><strong>جودة عالية:</strong> الصورة يجب أن تكون واضحة وحادة</li>
                                <li><strong>بدون نظارات:</strong> الوجه يجب أن يظهر بدون نظارات</li>
                                <li><strong>تعبير محايد:</strong> التعبير الوجهي يجب أن يكون طبيعياً ومحايداً</li>
                                <li><strong>عيون مفتوحة:</strong> العينان يجب أن تكونا مفتوحتين وواضحتين</li>
                                <li><strong>إضاءة جيدة:</strong> إضاءة موزعة بشكل متساوي على الوجه</li>
                                <li><strong>بدون غطاء رأس:</strong> الوجه يجب أن يظهر بدون أي غطاء للرأس</li>
                            </ul>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Action Buttons -->
                    <div class="action-buttons">
                        <?php if (!$allValid): ?>
                            <button onclick="resetForm()" class="action-btn reset-btn">
                                <i class="fas fa-sync-alt"></i> رفع صورة جديدة
                            </button>
                            <button onclick="window.location.reload()" class="action-btn upload-new-btn">
                                <i class="fas fa-redo"></i> إعادة تحميل الصفحة
                            </button>
                        <?php else: ?>
                            <button onclick="window.location.reload()" class="action-btn upload-new-btn">
                                <i class="fas fa-plus"></i> رفع صورة جديدة
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Show uploaded image in preview box -->
                <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        <?php if ($imagePreview): ?>
                            document.getElementById('imagePreview').src = '<?php echo htmlspecialchars($imagePreview); ?>';
                            document.getElementById('imagePreview').classList.add('show');
                            document.getElementById('previewPlaceholder').style.display = 'none';
                            document.getElementById('previewBox').classList.add('has-image');
                            
                            // Show image info
                            const fileInfo = document.createElement('div');
                            fileInfo.className = 'image-info-item';
                            fileInfo.innerHTML = 'صورة مرفوعة للتحقق';
                            document.getElementById('imageInfo').appendChild(fileInfo);
                        <?php endif; ?>
                    });
                </script>
            <?php endif; ?>
        </div>
    </div>

    <script>
        // Image preview functionality
        function previewImage(input) {
            const previewBox = document.getElementById('previewBox');
            const placeholder = document.getElementById('previewPlaceholder');
            const preview = document.getElementById('imagePreview');
            const imageInfo = document.getElementById('imageInfo');
            
            if (input.files && input.files[0]) {
                const file = input.files[0];
                const reader = new FileReader();
                
                reader.onload = function(e) {
                    // Show preview
                    preview.src = e.target.result;
                    preview.classList.add('show');
                    placeholder.style.display = 'none';
                    previewBox.classList.add('has-image');
                    
                    // Clear previous info
                    imageInfo.innerHTML = '';
                    
                    // Create image stats in Arabic
                    const fileSize = (file.size / 1024 / 1024).toFixed(2);
                    const fileType = file.type.split('/')[1]?.toUpperCase() || 'غير معروف';
                    
                    const img = new Image();
                    img.onload = function() {
                        const dimensionsText = `${this.width} × ${this.height} بكسل`;
                        
                        const sizeInfo = document.createElement('div');
                        sizeInfo.className = 'image-info-item';
                        sizeInfo.innerHTML = `الحجم: ${fileSize} ميجابايت`;
                        imageInfo.appendChild(sizeInfo);
                        
                        const typeInfo = document.createElement('div');
                        typeInfo.className = 'image-info-item';
                        typeInfo.innerHTML = `النوع: ${fileType}`;
                        imageInfo.appendChild(typeInfo);
                        
                        const dimInfo = document.createElement('div');
                        dimInfo.className = 'image-info-item';
                        dimInfo.innerHTML = `الأبعاد: ${dimensionsText}`;
                        imageInfo.appendChild(dimInfo);
                    };
                    img.src = e.target.result;
                };
                
                reader.readAsDataURL(file);
            } else {
                // Hide preview
                preview.classList.remove('show');
                placeholder.style.display = 'block';
                previewBox.classList.remove('has-image');
                imageInfo.innerHTML = '';
            }
            
            checkFormValidity();
        }
        
        // Reset form function
        function resetForm() {
            // Clear the form
            document.getElementById('student_number').value = '';
            document.getElementById('photo').value = '';
            
            // Reset preview
            document.getElementById('imagePreview').classList.remove('show');
            document.getElementById('previewPlaceholder').style.display = 'block';
            document.getElementById('previewBox').classList.remove('has-image');
            document.getElementById('imageInfo').innerHTML = '';
            
            // Reset hCaptcha
            hcaptcha.reset();
            
            // Hide validation results
            document.getElementById('validationResults').style.display = 'none';
            
            // Enable form
            document.getElementById('submitBtn').disabled = true;
        }
        
        // hCaptcha callbacks
        window.onCaptchaSuccess = function(response) {
            checkFormValidity();
        };
        
        window.onCaptchaExpired = function() {
            const submitBtn = document.getElementById('submitBtn');
            if (submitBtn) {
                submitBtn.disabled = true;
            }
        };
        
        // Check if all required fields are filled
        function checkFormValidity() {
            const studentNumber = document.getElementById('student_number')?.value.trim();
            const fileInput = document.getElementById('photo');
            const hcaptchaResponse = document.querySelector('[name="h-captcha-response"]')?.value || '';
            const submitBtn = document.getElementById('submitBtn');
            
            if (!submitBtn) return;
            
            const hasFile = fileInput && fileInput.files && fileInput.files.length > 0;
            const hasStudentNumber = studentNumber && studentNumber.length > 0;
            const hasCaptcha = hcaptchaResponse.length > 0;
            
            submitBtn.disabled = !(hasFile && hasStudentNumber && hasCaptcha);
        }
        
        // Add event listeners
        document.addEventListener('DOMContentLoaded', function() {
            const studentNumberInput = document.getElementById('student_number');
            if (studentNumberInput) {
                studentNumberInput.addEventListener('input', checkFormValidity);
            }
            
            const photoInput = document.getElementById('photo');
            if (photoInput) {
                photoInput.addEventListener('change', function(e) {
                    previewImage(this);
                });
            }
            
            // Form submission
            const uploadForm = document.getElementById('uploadForm');
            if (uploadForm) {
                uploadForm.addEventListener('submit', function(e) {
                    const studentNumber = document.getElementById('student_number').value.trim();
                    const fileInput = document.getElementById('photo');
                    const hcaptchaResponse = document.querySelector('[name="h-captcha-response"]')?.value || '';
                    const submitBtn = document.getElementById('submitBtn');
                    const submitText = document.getElementById('submitText');
                    
                    if (!studentNumber) {
                        alert('الرجاء إدخال رقم الطالب.');
                        e.preventDefault();
                        return;
                    }
                    
                    if (!fileInput.files || fileInput.files.length === 0) {
                        alert('الرجاء اختيار صورة.');
                        e.preventDefault();
                        return;
                    }
                    
                    if (!hcaptchaResponse) {
                        alert('الرجاء إكمال تحقق hCaptcha.');
                        e.preventDefault();
                        return;
                    }
                    
                    // Show loading state
                    if (submitText) {
                        submitText.innerHTML = '<i class="fas fa-spinner fa-spin"></i> جاري المعالجة...';
                    }
                    if (submitBtn) {
                        submitBtn.disabled = true;
                    }
                });
            }
            
            // Initialize
            checkFormValidity();
        });
    </script>
</body>
</html>