<?php
// Add-student.php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

require 'db.php';
require 'helpers.php';
require_committee();

$committeeId   = (int)($_SESSION['committee_id'] ?? 0);
$committeeName = (string)($_SESSION['committee_name'] ?? '');
$canAll        = (bool)($_SESSION['committee_can_all'] ?? false);
$scopeCollege  = isset($_SESSION['committee_college_id']) ? (int)$_SESSION['committee_college_id'] : null;

// Get dropdown data
$colleges_stmt = $mysqli1->prepare("SELECT id, name FROM colleges WHERE deleted_at IS NULL ORDER BY name");
$colleges_stmt->execute();
$colleges = $colleges_stmt->get_result()->fetch_all(MYSQLI_ASSOC);

$programs_stmt = $mysqli1->prepare("SELECT id, name FROM programs WHERE deleted_at IS NULL ORDER BY name");
$programs_stmt->execute();
$programs = $programs_stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// Get ALL sections
$all_sections_stmt = $mysqli1->prepare("SELECT id, name, parent FROM sections WHERE deleted_at IS NULL ORDER BY name");
$all_sections_stmt->execute();
$all_sections = $all_sections_stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// Fetch batches
$batches_stmt = $mysqli1->prepare("SELECT id, value FROM batches WHERE deleted_at IS NULL ORDER BY value");
$batches_stmt->execute();
$batches = $batches_stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// Fetch admissions types - بدون التحقق من deleted_at إذا لم يكن موجوداً
try {
    $admissions_stmt = $mysqli1->prepare("SELECT id, name FROM admissions ORDER BY name");
    $admissions_stmt->execute();
    $admissions = $admissions_stmt->get_result()->fetch_all(MYSQLI_ASSOC);
} catch (Exception $e) {
    // إذا كان هناك خطأ، ربما لأن deleted_at غير موجود
    $admissions_stmt = $mysqli1->prepare("SELECT id, name FROM admissions ORDER BY name");
    $admissions_stmt->execute();
    $admissions = $admissions_stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}

// إعادة تعبئة النموذج في حالة وجود خطأ
$form_data = $_SESSION['form_data'] ?? [];
unset($_SESSION['form_data']);

// دالة مساعدة للقيم السابقة
function old($field, $default = '') {
    global $form_data;
    return isset($form_data[$field]) ? e($form_data[$field]) : $default;
}

// If committee has restricted access
if (!$canAll && $scopeCollege !== null) {
    $filtered_colleges = array_filter($colleges, function($college) use ($scopeCollege) {
        return $college['id'] == $scopeCollege;
    });
    $colleges = $filtered_colleges ?: [];
}

include 'header.php';
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إضافة طالب جديد - لوحة اللجنة</title>
    
    <!-- Bootstrap 5 RTL -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap RTL -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Fonts: Cairo -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --bs-font-sans-serif: 'Cairo', system-ui, -apple-system, sans-serif;
        }
        
        body, h1, h2, h3, h4, h5, h6, p, a, button, label, input, select, textarea, .form-control, .form-select, .btn {
            font-family: 'Cairo', system-ui, -apple-system, sans-serif !important;
            text-align: right !important;
        }
        
        .form-control, .form-select {
            text-align: right;
            direction: rtl;
        }
        
        .form-check {
            padding-right: 1.5em;
            padding-left: 0;
        }
        
        .form-check-input {
            float: right;
            margin-right: -1.5em;
            margin-left: 0;
        }
        
        .required::after {
            content: " *";
            color: #dc3545;
        }
        
        .rtl-heading {
            text-align: right;
            font-weight: 700;
            color: #1F3A2E;
            border-right: 4px solid #2ecc71;
            padding-right: 15px;
            margin: 20px 0;
        }
        
        .card-arabic {
            border: 1px solid #e5e7eb;
            border-radius: 16px;
            background: #fff;
            box-shadow: 0 10px 24px rgba(0,0,0,.06);
            margin-bottom: 20px;
        }
        
        .generated-id {
            background-color: #e8f5e9 !important;
            font-weight: bold;
            color: #2e7d32;
            border-color: #81c784;
        }
        
        .manual-entry {
            background-color: #fff3cd !important;
            font-weight: bold;
            color: #856404;
            border-color: #ffeaa7;
        }
        
        .spinner-border-sm {
            width: 1rem;
            height: 1rem;
            border-width: 0.2em;
        }
        
        .error-message {
            color: #dc3545;
            font-size: 0.875em;
            margin-top: 0.25rem;
        }
        
        .mode-indicator {
            font-size: 0.85rem;
            padding: 8px 12px;
            border-radius: 6px;
            margin-top: 8px;
            display: block;
            line-height: 1.5;
        }
        
        .mode-auto {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        
        .mode-manual {
            background-color: #fff3cd;
            color: #856404;
            border: 1px solid #ffeaa7;
        }
        
        .btn-group-mode {
            margin-top: 5px;
        }
        
        .btn-mode {
            font-size: 0.85rem;
            padding: 0.35rem 0.75rem;
        }
        
        .form-section {
            background-color: #f8f9fa;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            border: 1px solid #e9ecef;
        }
        
        .section-title {
            color: #2c3e50;
            font-weight: 600;
            margin-bottom: 15px;
            padding-bottom: 8px;
            border-bottom: 2px solid #3498db;
        }
    </style>
</head>
<body class="bg-light">
    <div class="container py-4" dir="rtl">
        <!-- Header -->
        <div class="d-flex align-items-center mb-4">
            <h3 class="mb-0 fw-bold text-dark">
                <i class="fas fa-user-plus ms-2"></i>إضافة طالب جديد
            </h3>
            <div class="me-auto">
                <a class="btn btn-outline-secondary" href="admin_dashboard.php">
                    <i class="fas fa-arrow-right me-2"></i>العودة لقائمة الطلاب
                </a>
            </div>
        </div>

        <?php if (isset($_SESSION['success_message'])): ?>
            <div class="alert alert-success alert-dismissible fade show alert-custom" role="alert">
                <i class="fas fa-check-circle ms-2"></i>
                <?= e($_SESSION['success_message']) ?>
                <button type="button" class="btn-close float-start" data-bs-dismiss="alert"></button>
            </div>
            <?php unset($_SESSION['success_message']); ?>
        <?php endif; ?>

        <?php if (isset($_SESSION['error_message'])): ?>
            <div class="alert alert-danger alert-dismissible fade show alert-custom" role="alert">
                <i class="fas fa-exclamation-circle ms-2"></i>
                <?= e($_SESSION['error_message']) ?>
                <button type="button" class="btn-close float-start" data-bs-dismiss="alert"></button>
            </div>
            <?php unset($_SESSION['error_message']); ?>
        <?php endif; ?>

        <!-- Add Student Form -->
        <div class="card card-arabic p-4">
            <form action="save_student.php" method="POST" id="studentForm">
                
                <!-- القسم 1: البيانات الأساسية -->
                <div class="form-section">
                    <h5 class="section-title">
                        <i class="fas fa-id-card ms-3"></i>البيانات الأساسية للطالب
                    </h5>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="student_id" class="form-label required">
                                    <i class="fas fa-hashtag ms-2"></i>رقم الطالب
                                    <span class="badge bg-info ms-2" data-bs-toggle="tooltip" title="يتم توليد الرقم تلقائياً: أكبر رقم في نفس القسم والدفعة + 1">
                                        <i class="fas fa-info-circle"></i>
                                    </span>
                                </label>
                                <div class="input-group">
                                    <input type="text" class="form-control text-end generated-id" name="student_id" id="student_id" required
                                           placeholder="سيتم توليد الرقم تلقائياً" dir="ltr" readonly
                                           value="<?= old('student_id') ?>">
                                    <button type="button" class="btn btn-outline-primary" id="generateIdBtn">
                                        <i class="fas fa-sync-alt ms-2"></i>توليد رقم طالب
                                    </button>
                                </div>
                                
                                <!-- Mode selector buttons -->
                                <div class="btn-group-mode d-flex gap-2 mt-2">
                                    <button type="button" class="btn btn-success btn-sm btn-mode active" id="btnAutoMode" data-mode="auto">
                                        <i class="fas fa-robot ms-1"></i>توليد تلقائي
                                    </button>
                                    <button type="button" class="btn btn-warning btn-sm btn-mode" id="btnManualMode" data-mode="manual">
                                        <i class="fas fa-edit ms-1"></i>إدخال يدوي
                                    </button>
                                </div>
                                
                                <!-- Mode indicator -->
                                <div id="modeIndicator" class="mode-indicator mode-auto">
                                    <i class="fas fa-robot ms-1"></i>
                                    <strong>وضع التوليد التلقائي</strong><br>
                                    <small>سيتم توليد الرقم: (أكبر رقم في نفس القسم والدفعة + 1)</small>
                                </div>
                                
                                <!-- Error message container -->
                                <div id="studentIdError" class="error-message"></div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label required">
                                    <i class="fas fa-user ms-2"></i>الاسم بالعربية
                                </label>
                                <input type="text" class="form-control" name="student_name" required
                                       placeholder="أدخل الاسم الكامل بالعربية"
                                       value="<?= old('student_name') ?>">
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label required">
                                    <i class="fas fa-venus-mars ms-2"></i>الجنس
                                </label>
                                <div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="gender" id="gender_male" value="1" required
                                               <?= (old('gender') == '1') ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="gender_male">
                                            <i class="fas fa-male ms-1"></i>ذكر
                                        </label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="gender" id="gender_female" value="2"
                                               <?= (old('gender') == '2') ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="gender_female">
                                            <i class="fas fa-female ms-1"></i>أنثى
                                        </label>
                                    </div>
                                </div>
                                <div class="error-message" id="genderError"></div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label required">
                                    <i class="fas fa-university ms-2"></i>الكلية
                                </label>
                                <select class="form-select" name="college_id" id="college_id" onchange="loadSections()" required
                                    <?= (!$canAll && $scopeCollege !== null) ? 'disabled' : '' ?>>
                                    <option value="">اختر الكلية</option>
                                    <?php foreach ($colleges as $college): ?>
                                        <option value="<?= e($college['id'] ?? '') ?>"
                                            <?= ((!$canAll && $scopeCollege !== null && $scopeCollege == $college['id']) || old('college_id') == $college['id']) ? 'selected' : '' ?>>
                                            <?= e($college['name'] ?? '') ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                                <?php if (!$canAll && $scopeCollege !== null): ?>
                                    <input type="hidden" name="college_id" value="<?= e($scopeCollege) ?>">
                                    <div class="form-text">يتم تعيين الكلية بناءً على صلاحياتك</div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label required">
                                    <i class="fas fa-graduation-cap ms-2"></i>البرنامج
                                </label>
                                <select class="form-select" name="program_id" id="program_id" required>
                                    <option value="">اختر البرنامج</option>
                                    <?php foreach ($programs as $program): ?>
                                        <option value="<?= e($program['id'] ?? '') ?>"
                                            <?= (old('program_id') == $program['id']) ? 'selected' : '' ?>>
                                            <?= e($program['name'] ?? '') ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label required">
                                    <i class="fas fa-building ms-2"></i>القسم
                                </label>
                                <select class="form-select" name="section_id" id="section_id" required>
                                    <option value="">اختر القسم</option>
                                    <!-- Sections will be populated by JavaScript -->
                                </select>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label required">
                                    <i class="fas fa-users ms-2"></i>الدفعة
                                </label>
                                <select class="form-select" name="batch_id" id="batch_id" required>
                                    <option value="">اختر الدفعة</option>
                                    <?php foreach ($batches as $batch): ?>
                                        <option value="<?= e($batch['id'] ?? '') ?>"
                                            <?= (old('batch_id') == $batch['id']) ? 'selected' : '' ?>>
                                            <?= e($batch['value'] ?? '') ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- القسم 2: المعلومات الإدارية -->
                <div class="form-section">
                    <h5 class="section-title">
                        <i class="fas fa-cogs ms-3"></i>المعلومات الإدارية
                    </h5>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">
                                    <i class="fas fa-tag ms-2"></i>نوع القبول
                                </label>
                                <select class="form-select" name="admission_type_id">
                                    <option value="0">اختر نوع القبول</option>
                                    <?php foreach ($admissions as $admission): ?>
                                        <option value="<?= e($admission['id'] ?? '') ?>"
                                            <?= (old('admission_type_id') == $admission['id']) ? 'selected' : '' ?>>
                                            <?= e($admission['name'] ?? '') ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">
                                    <i class="fas fa-heartbeat ms-2"></i>الحالة الطبية
                                </label>
                                <select class="form-select" name="medically_fit">
                                    <option value="pending" <?= (old('medically_fit', 'pending') == 'pending') ? 'selected' : '' ?>>قيد الانتظار</option>
                                    <option value="completed" <?= (old('medically_fit') == 'completed') ? 'selected' : '' ?>>مكتمل</option>
                                    <option value="exempted" <?= (old('medically_fit') == 'exempted') ? 'selected' : '' ?>>معفى</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">
                                    <i class="fas fa-clipboard-check ms-2"></i>حالة القرار
                                </label>
                                <select class="form-select" name="decision_status">
                                    <option value="pending" <?= (old('decision_status', 'pending') == 'pending') ? 'selected' : '' ?>>قيد الانتظار</option>
                                    <option value="accepted" <?= (old('decision_status') == 'accepted') ? 'selected' : '' ?>>مقبول</option>
                                    <option value="rejected" <?= (old('decision_status') == 'rejected') ? 'selected' : '' ?>>مرفوض</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">
                                    <i class="fas fa-folder ms-2"></i>حالة الملف
                                </label>
                                <select class="form-select" name="profile_completed">
                                    <option value="0" <?= (old('profile_completed', '0') == '0') ? 'selected' : '' ?>>غير مكتمل</option>
                                    <option value="1" <?= (old('profile_completed') == '1') ? 'selected' : '' ?>>مكتمل</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- القسم 3: المعلومات المالية -->
                <div class="form-section">
                    <h5 class="section-title">
                        <i class="fas fa-money-bill-wave ms-3"></i>المعلومات المالية
                    </h5>
                    
                    <div class="row">
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label class="form-label">رسوم البرنامج</label>
                                <div class="input-group">
                                    <input type="number" step="0.01" class="form-control text-end" name="program_fees"
                                           placeholder="رسوم البرنامج" dir="ltr" 
                                           value="<?= old('program_fees', '0') ?>">
                                    <span class="input-group-text">ج.س</span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label class="form-label">رسوم التسجيل</label>
                                <div class="input-group">
                                    <input type="number" step="0.01" class="form-control text-end" name="registration_fees"
                                           placeholder="رسوم التسجيل" 
                                           value="<?= old('registration_fees', '0') ?>" dir="ltr">
                                    <span class="input-group-text">ج.س</span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label class="form-label">رسوم التأمين</label>
                                <div class="input-group">
                                    <input type="number" step="0.01" class="form-control text-end" name="insurance_fees"
                                           placeholder="رسوم التأمين" 
                                           value="<?= old('insurance_fees', '0') ?>" dir="ltr">
                                    <span class="input-group-text">ج.س</span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label class="form-label">الخصم (%)</label>
                                <div class="input-group">
                                    <input type="number" step="0.01" class="form-control text-end" name="discount"
                                           placeholder="نسبة الخصم" 
                                           value="<?= old('discount', '0') ?>" dir="ltr">
                                    <span class="input-group-text">%</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-info mb-0">
                                <i class="fas fa-info-circle ms-2"></i>
                                <strong>ملاحظة:</strong> يمكنك ترك القيم المالية صفراً إذا لم تكن متوفرة حالياً.
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- أزرار التحكم -->
                <div class="row mt-4 pt-3 border-top">
                    <div class="col-12">
                        <div class="d-flex justify-content-start gap-2">
                            <button type="submit" class="btn btn-success px-4 py-2">
                                <i class="fas fa-user-plus ms-2"></i>إضافة الطالب
                            </button>
                            <a href="admin_dashboard.php" class="btn btn-secondary px-4 py-2">
                                <i class="fas fa-times ms-2"></i>إلغاء
                            </a>
                            <button type="reset" class="btn btn-outline-warning px-4 py-2" id="resetBtn">
                                <i class="fas fa-redo ms-2"></i>إعادة تعيين
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <script>
        // تخزين بيانات جميع الأقسام للتصفية
        const allSections = <?= json_encode($all_sections) ?>;
        let isManualEntry = false;

        // دالة لتحميل القسم المحدد سابقاً
        function loadSelectedSection() {
            const selectedSectionId = "<?= old('section_id') ?>";
            const collegeId = document.getElementById('college_id').value;
            
            if (!collegeId) return;
            
            const sectionSelect = document.getElementById('section_id');
            sectionSelect.innerHTML = '<option value="">اختر القسم</option>';
            
            // تصفية الأقسام حسب الكلية
            const filteredSections = allSections.filter(section => section.parent == collegeId);
            
            filteredSections.forEach(section => {
                const option = document.createElement('option');
                option.value = section.id;
                option.textContent = section.name;
                
                // تحديد القسم المحدد سابقاً
                if (section.id == selectedSectionId) {
                    option.selected = true;
                }
                
                sectionSelect.appendChild(option);
            });
        }

        // دالة للتبديل بين الوضع التلقائي واليدوي
        function toggleEntryMode(mode) {
            const studentIdInput = document.getElementById('student_id');
            const generateBtn = document.getElementById('generateIdBtn');
            const btnAutoMode = document.getElementById('btnAutoMode');
            const btnManualMode = document.getElementById('btnManualMode');
            const modeIndicator = document.getElementById('modeIndicator');
            
            isManualEntry = (mode === 'manual');
            
            if (isManualEntry) {
                // التبديل إلى الوضع اليدوي
                studentIdInput.readOnly = false;
                studentIdInput.placeholder = "أدخل رقم الطالب يدوياً";
                studentIdInput.classList.remove('generated-id');
                studentIdInput.classList.add('manual-entry');
                generateBtn.disabled = true;
                
                // تحديث الأزرار
                btnAutoMode.classList.remove('active', 'btn-success');
                btnAutoMode.classList.add('btn-outline-success');
                btnManualMode.classList.add('active', 'btn-warning');
                btnManualMode.classList.remove('btn-outline-warning');
                
                // تحديث المؤشر
                modeIndicator.className = "mode-indicator mode-manual";
                modeIndicator.innerHTML = `
                    <i class="fas fa-edit ms-1"></i>
                    <strong>وضع الإدخال اليدوي</strong><br>
                    <small>يمكنك إدخال أي رقم ترغب فيه</small>
                `;
                
            } else {
                // التبديل إلى الوضع التلقائي
                studentIdInput.readOnly = true;
                studentIdInput.placeholder = "سيتم توليد الرقم تلقائياً";
                studentIdInput.classList.remove('manual-entry');
                studentIdInput.classList.add('generated-id');
                generateBtn.disabled = false;
                
                // تحديث الأزرار
                btnAutoMode.classList.add('active', 'btn-success');
                btnAutoMode.classList.remove('btn-outline-success');
                btnManualMode.classList.remove('active', 'btn-warning');
                btnManualMode.classList.add('btn-outline-warning');
                
                // تحديث المؤشر
                modeIndicator.className = "mode-indicator mode-auto";
                modeIndicator.innerHTML = `
                    <i class="fas fa-robot ms-1"></i>
                    <strong>وضع التوليد التلقائي</strong><br>
                    <small>سيتم توليد الرقم: (أكبر رقم في نفس القسم والدفعة + 1)</small>
                `;
                
                // محاولة توليد الرقم إذا توافرت الشروط
                autoGenerateIfConditionsMet();
            }
        }

        // دالة تحميل الأقسام بناءً على الكلية المحددة
        function loadSections() {
            const collegeId = document.getElementById('college_id').value;
            const sectionSelect = document.getElementById('section_id');
            
            // إظهار حالة التحميل
            sectionSelect.innerHTML = '<option value="">جاري تحميل الأقسام...</option>';
            
            // تأخير بسيط لإظهار التحميل
            setTimeout(() => {
                // تصفية الأقسام حسب الكلية
                const filteredSections = allSections.filter(section => section.parent == collegeId);
                
                if (filteredSections.length === 0) {
                    sectionSelect.innerHTML = '<option value="">لا توجد أقسام لهذه الكلية</option>';
                    return;
                }
                
                sectionSelect.innerHTML = '<option value="">اختر القسم</option>';
                filteredSections.forEach(section => {
                    const option = document.createElement('option');
                    option.value = section.id;
                    option.textContent = section.name;
                    sectionSelect.appendChild(option);
                });
                
                // محاولة التوليد التلقائي إذا توافرت الشروط
                setTimeout(() => {
                    autoGenerateIfConditionsMet();
                }, 100);
            }, 300);
        }

        // دالة توليد رقم الطالب التالي
        function generateNextStudentId() {
            const sectionId = document.getElementById('section_id').value;
            const batchId = document.getElementById('batch_id').value;
            
            // التحقق من القسم والدفعة
            if (!sectionId || !batchId) {
                alert('❌ الرجاء اختيار القسم والدفعة أولاً لتوليد رقم الطالب');
                return;
            }
            
            const studentIdInput = document.getElementById('student_id');
            const generateBtn = document.getElementById('generateIdBtn');
            const errorContainer = document.getElementById('studentIdError');
            const modeIndicator = document.getElementById('modeIndicator');
            
            // حفظ النص الأصلي للزر
            const originalBtnText = generateBtn.innerHTML;
            generateBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>جاري توليد الرقم...';
            generateBtn.disabled = true;
            
            // مسح الأخطاء السابقة
            errorContainer.textContent = '';
            studentIdInput.classList.remove('is-invalid');
            
            // استدعاء API للحصول على رقم الطالب التالي
            $.ajax({
                url: 'generate_student_id.php',
                type: 'POST',
                data: {
                    section_id: sectionId,
                    batch_id: batchId
                },
                dataType: 'json',
                timeout: 10000,
                success: function(response) {
                    console.log('✅ استجابة API:', response);
                    
                    if (response.success) {
                        studentIdInput.value = response.next_student_id;
                        studentIdInput.classList.remove('is-invalid');
                        studentIdInput.classList.add('is-valid', 'generated-id');
                        
                        // عرض رسالة توضيحية
                        let indicatorHtml = `
                            <i class="fas fa-check-circle ms-1 text-success"></i>
                            <strong>${response.message}</strong><br>
                        `;
                        
                        if (response.last_student_id) {
                            indicatorHtml += `<small class="text-success">
                                <i class="fas fa-calculator ms-1"></i>
                                ${response.last_student_id} → ${response.next_student_id}
                            </small>`;
                        } else {
                            indicatorHtml += `<small class="text-info">
                                <i class="fas fa-star ms-1"></i>
                                أول طالب في هذا القسم والدفعة
                            </small>`;
                        }
                        
                        if (response.details) {
                            indicatorHtml += `<br><small class="text-muted">${response.details}</small>`;
                        }
                        
                        modeIndicator.innerHTML = indicatorHtml;
                        
                    } else {
                        const errorMsg = '❌ ' + response.message;
                        errorContainer.textContent = errorMsg;
                        studentIdInput.classList.add('is-invalid');
                        studentIdInput.classList.remove('generated-id');
                        
                        // تحديث المؤشر
                        modeIndicator.innerHTML = `
                            <i class="fas fa-exclamation-triangle ms-1 text-danger"></i>
                            <strong class="text-danger">${response.message}</strong>
                        `;
                        
                        alert(errorMsg);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('❌ تفاصيل خطأ AJAX:');
                    console.error('الحالة:', status);
                    console.error('الخطأ:', error);
                    console.error('الرد:', xhr.responseText);
                    
                    let errorMessage = 'حدث خطأ في الاتصال بالخادم';
                    
                    if (status === 'timeout') {
                        errorMessage = 'انتهت مهلة الاتصال. الرجاء المحاولة مرة أخرى.';
                    }
                    
                    errorContainer.textContent = '❌ ' + errorMessage;
                    studentIdInput.classList.add('is-invalid');
                    studentIdInput.classList.remove('generated-id');
                    
                    // تحديث المؤشر
                    modeIndicator.innerHTML = `
                        <i class="fas fa-exclamation-triangle ms-1 text-danger"></i>
                        <strong class="text-danger">${errorMessage}</strong>
                    `;
                    
                    alert(`خطأ: ${errorMessage}`);
                },
                complete: function() {
                    // استعادة حالة الزر الأصلية
                    generateBtn.innerHTML = originalBtnText;
                    generateBtn.disabled = false;
                }
            });
        }

        // دالة التوليد التلقائي إذا توافرت الشروط
        function autoGenerateIfConditionsMet() {
            if (isManualEntry) return;
            
            const sectionId = document.getElementById('section_id').value;
            const batchId = document.getElementById('batch_id').value;
            const studentIdInput = document.getElementById('student_id');
            
            // التحقق من أن القسم والدفعة محددين وأن حقل رقم الطالب فارغ
            if (sectionId && batchId && !studentIdInput.value) {
                console.log('🚀 الشروط متوفرة، جاري التوليد التلقائي...');
                generateNextStudentId();
            }
        }

        // التهيئة عند تحميل الصفحة
        document.addEventListener('DOMContentLoaded', function() {
            console.log('📱 صفحة إضافة طالب جاهزة');
            
            // تحميل القسم المحدد سابقاً إذا كان هناك بيانات
            const hasFormData = "<?= !empty($form_data) ? 'true' : 'false' ?>";
            if (hasFormData === 'true') {
                loadSelectedSection();
                
                // التحقق من وضع الإدخال
                const studentIdValue = document.getElementById('student_id').value;
                if (studentIdValue) {
                    toggleEntryMode('manual');
                }
            }
            
            // إذا كانت الكلية محددة مسبقاً (بسبب الصلاحيات)، تحميل أقسامها
            const collegeSelect = document.getElementById('college_id');
            const initialCollegeId = collegeSelect.value;
            
            if (initialCollegeId && !hasFormData) {
                console.log('🏛️ تحميل أقسام الكلية المحددة مسبقاً...');
                loadSections();
            }
            
            // إضافة مستمع حدث لزر التوليد
            document.getElementById('generateIdBtn').addEventListener('click', generateNextStudentId);
            
            // إضافة مستمعي الأحداث لأزرار الوضع
            document.getElementById('btnAutoMode').addEventListener('click', function() {
                console.log('🔄 التبديل إلى الوضع التلقائي');
                toggleEntryMode('auto');
            });
            
            document.getElementById('btnManualMode').addEventListener('click', function() {
                console.log('✏️ التبديل إلى الوضع اليدوي');
                toggleEntryMode('manual');
            });
            
            // التوليد التلقائي عند اختيار القسم والدفعة
            document.getElementById('section_id').addEventListener('change', function() {
                console.log('📌 تم تغيير القسم:', this.value);
                autoGenerateIfConditionsMet();
            });
            
            document.getElementById('batch_id').addEventListener('change', function() {
                console.log('👥 تم تغيير الدفعة:', this.value);
                autoGenerateIfConditionsMet();
            });
            
            // التحقق من صحة النموذج قبل الإرسال
            const form = document.getElementById('studentForm');
            form.addEventListener('submit', function(e) {
                console.log('📤 محاولة إرسال النموذج...');
                
                // التحقق من الحقول المطلوبة
                const requiredFields = form.querySelectorAll('[required]');
                let isValid = true;
                
                requiredFields.forEach(field => {
                    if (!field.value.trim()) {
                        field.classList.add('is-invalid');
                        isValid = false;
                        console.log('❌ حقل مطلوب فارغ:', field.name);
                    } else {
                        field.classList.remove('is-invalid');
                        if (field.id === 'student_id') {
                            if (isManualEntry) {
                                field.classList.add('is-valid', 'manual-entry');
                            } else {
                                field.classList.add('is-valid', 'generated-id');
                            }
                        }
                    }
                });
                
                // التحقق من اختيار الجنس
                const genderSelected = document.querySelector('input[name="gender"]:checked');
                if (!genderSelected) {
                    document.getElementById('gender_male').classList.add('is-invalid');
                    document.getElementById('gender_female').classList.add('is-invalid');
                    document.getElementById('genderError').textContent = 'الرجاء اختيار الجنس';
                    isValid = false;
                    console.log('❌ الجنس غير محدد');
                } else {
                    document.getElementById('gender_male').classList.remove('is-invalid');
                    document.getElementById('gender_female').classList.remove('is-invalid');
                    document.getElementById('genderError').textContent = '';
                }
                
                if (!isValid) {
                    e.preventDefault();
                    alert('❌ الرجاء ملء جميع الحقول المطلوبة (المميزة بعلامة *)');
                    return false;
                }
                
                // تحقق إضافي لرقم الطالب في الوضع اليدوي
const studentIdInput = document.getElementById('student_id');
if (isManualEntry && studentIdInput.value.trim()) {
    // إزالة التحقق من النوع الرقمي فقط
    const studentId = studentIdInput.value.trim();
    
    // فقط التحقق من أن الحقل غير فارغ
    if (studentId === '') {
        e.preventDefault();
        alert('❌ الرجاء إدخال رقم الطالب');
        studentIdInput.focus();
        return false;
    }
    
    // التحقق من طول معقول (اختياري)
    if (studentId.length > 50) {
        e.preventDefault();
        alert('❌ رقم الطالب طويل جداً. الحد الأقصى 50 حرفاً');
        studentIdInput.focus();
        return false;
    }
}
                
                // التحقق من القسم والدفعة
                const sectionId = document.getElementById('section_id').value;
                const batchId = document.getElementById('batch_id').value;
                
                if (!sectionId || !batchId) {
                    e.preventDefault();
                    alert('❌ الرجاء اختيار القسم والدفعة');
                    return false;
                }
                
                console.log('✅ النموذج صالح، جاري الإرسال...');
                
                // إظهار رسالة تأكيد
                const confirmMsg = `
                    تأكيد إضافة الطالب:
                    
                    📝 الاسم: ${document.querySelector('[name="student_name"]').value}
                    🔢 الرقم: ${studentIdInput.value}
                    🏛️ القسم: ${document.getElementById('section_id').options[document.getElementById('section_id').selectedIndex].text}
                    👥 الدفعة: ${document.getElementById('batch_id').options[document.getElementById('batch_id').selectedIndex].text}
                    
                    هل تريد متابعة الإضافة؟
                `;
                
                if (!confirm(confirmMsg)) {
                    e.preventDefault();
                    return false;
                }
                
                return true;
            });
            
            // إعادة تعيين النموذج
            document.getElementById('resetBtn').addEventListener('click', function() {
                console.log('🔄 إعادة تعيين النموذج');
                
                // إعادة تعيين الحقول
                form.reset();
                
                // إعادة تعيين الوضع إلى التلقائي
                setTimeout(() => {
                    toggleEntryMode('auto');
                    autoGenerateIfConditionsMet();
                }, 500);
                
                // إعادة تحميل الأقسام إذا كانت الكلية محددة
                if (document.getElementById('college_id').value) {
                    loadSections();
                }
            });
            
            // تهيئة التلميحات
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            const tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
            
            console.log('🎯 نظام إضافة الطلاب جاهز للاستخدام');
        });
        </script>
    </div>

    <!-- Bootstrap & jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>