<?php
// ajax/get_specializations.php
require_once '../db.php';
header('Content-Type: application/json');

try {
    $section_id = isset($_GET['section_id']) ? (int)$_GET['section_id'] : 0;
    $program_id = isset($_GET['program_id']) ? (int)$_GET['program_id'] : 0;
    
    if ($section_id <= 0 || $program_id <= 0) {
        echo json_encode([]);
        exit;
    }
    
    $stmt = $mysqli1->prepare("
        SELECT specialization_id, specialization_name_ar 
        FROM specializations 
        WHERE section_id = ? AND program_id = ? AND deleted_at IS NULL 
        ORDER BY specialization_name_ar
    ");
    $stmt->bind_param('ii', $section_id, $program_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $specializations = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
    
    echo json_encode($specializations);
    
} catch (Exception $e) {
    error_log("Error in get_specializations.php: " . $e->getMessage());
    echo json_encode([]);
}
?>