<?php
// check_admin.php - Check and fix admin user in database
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Start session to check if we're logged in
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Connect to database
require 'db.php';

$mysqli1->set_charset('utf8mb4');
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// Helper function
function e($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

// Check current session
$is_logged_in = isset($_SESSION['committee_id']);
$current_user_id = $_SESSION['committee_id'] ?? 0;
$current_user_name = $_SESSION['committee_name'] ?? 'Guest';

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فحص مستخدم المسؤول</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body, h1,h2,h3,h4,h5,h6, p, a, button, label { 
            font-family: 'Cairo', system-ui, -apple-system, sans-serif !important; 
        }
        .container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 20px;
        }
        .card {
            background: white;
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 20px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            border: 1px solid #e0e0e0;
        }
        .success { color: #28a745; }
        .error { color: #dc3545; }
        .warning { color: #ffc107; }
        .info { color: #17a2b8; }
        pre {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            border: 1px solid #dee2e6;
            overflow-x: auto;
            font-family: 'Courier New', monospace;
            direction: ltr;
        }
        .btn {
            padding: 10px 20px;
            border-radius: 6px;
            border: none;
            cursor: pointer;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
            margin: 5px;
            transition: all 0.3s;
        }
        .btn-primary {
            background: #007bff;
            color: white;
        }
        .btn-success {
            background: #28a745;
            color: white;
        }
        .btn-danger {
            background: #dc3545;
            color: white;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }
        .status-badge {
            padding: 5px 10px;
            border-radius: 20px;
            font-size: 0.9rem;
            font-weight: 600;
        }
        .status-active { background: #d4edda; color: #155724; }
        .status-inactive { background: #f8d7da; color: #721c24; }
        .test-section {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin: 15px 0;
        }
        .session-info {
            background: #e8f4fd;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="text-center mb-4">
            <i class="fas fa-user-shield me-2"></i>
            فحص وتصحيح مستخدم المسؤول
        </h1>
        
        <!-- Session Information -->
        <div class="session-info">
            <h3><i class="fas fa-user-circle me-2"></i>معلومات الجلسة الحالية</h3>
            <p>الحالة: 
                <?php if ($is_logged_in): ?>
                    <span class="status-badge status-active">مسجل دخول</span>
                <?php else: ?>
                    <span class="status-badge status-inactive">غير مسجل</span>
                <?php endif; ?>
            </p>
            <p>معرف المستخدم: <strong><?= e($current_user_id) ?></strong></p>
            <p>اسم المستخدم: <strong><?= e($current_user_name) ?></strong></p>
            <p>committee_can_all في الجلسة: <strong><?= e($_SESSION['committee_can_all'] ?? 'غير معين') ?></strong></p>
        </div>
        
        <?php
        try {
            // Check if admin user exists
            $stmt = $mysqli1->prepare("SELECT * FROM committee_users WHERE username = 'admin'");
            $stmt->execute();
            $result = $stmt->get_result();
            $admin = $result->fetch_assoc();
            $stmt->close();
            
            if (!$admin) {
                // Admin user doesn't exist
                ?>
                <div class="card">
                    <h2 class="error"><i class="fas fa-exclamation-triangle me-2"></i>المسؤول غير موجود</h2>
                    <p>مستخدم المسؤول (admin) غير موجود في قاعدة البيانات.</p>
                    
                    <div class="test-section">
                        <h4>حاول إنشاء مستخدم المسؤول</h4>
                        <form method="post" action="">
                            <input type="hidden" name="create_admin" value="1">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-plus-circle me-2"></i>إنشاء مستخدم المسؤول
                            </button>
                        </form>
                    </div>
                </div>
                <?php
            } else {
                // Admin user exists
                ?>
                <div class="card">
                    <h2 class="success"><i class="fas fa-check-circle me-2"></i>مستخدم المسؤول موجود</h2>
                    
                    <h3>تفاصيل المستخدم:</h3>
                    <pre><?php print_r($admin); ?></pre>
                    
                    <h3>التحقق من الصلاحيات:</h3>
                    <ul>
                        <li><strong>اسم المستخدم:</strong> <?= e($admin['username']) ?></li>
                        <li><strong>الاسم الكامل:</strong> <?= e($admin['name']) ?></li>
                        <li><strong>can_view_all:</strong> 
                            <?php if ($admin['can_view_all'] == 1): ?>
                                <span class="status-badge status-active">نعم (1)</span>
                            <?php else: ?>
                                <span class="status-badge status-inactive">لا (<?= e($admin['can_view_all']) ?>)</span>
                            <?php endif; ?>
                        </li>
                        <li><strong>role_id:</strong> <?= e($admin['role_id'] ?? 'غير معين') ?></li>
                        <li><strong>role_name:</strong> <?= e($admin['role_name'] ?? 'غير معين') ?></li>
                        <li><strong>تاريخ الإنشاء:</strong> <?= e($admin['created_at']) ?></li>
                    </ul>
                    
                    <?php if ($admin['can_view_all'] != 1): ?>
                    <div class="test-section">
                        <h4 class="warning"><i class="fas fa-exclamation-triangle me-2"></i>مستخدم المسؤول لا يملك صلاحية can_view_all = 1</h4>
                        <form method="post" action="">
                            <input type="hidden" name="fix_permissions" value="1">
                            <button type="submit" class="btn btn-warning">
                                <i class="fas fa-wrench me-2"></i>إصلاح صلاحيات المسؤول
                            </button>
                        </form>
                    </div>
                    <?php endif; ?>
                </div>
                
                <div class="card">
                    <h3>اختبار تسجيل الدخول كمسؤول</h3>
                    <form method="post" action="login.php" target="_blank">
                        <input type="hidden" name="username" value="admin">
                        <input type="hidden" name="password" value="admin#778855">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-sign-in-alt me-2"></i>تجربة تسجيل الدخول كـ admin
                        </button>
                    </form>
                </div>
                <?php
            }
            
            // Handle POST requests
            if ($_SERVER['REQUEST_METHOD'] === 'POST') {
                if (isset($_POST['create_admin'])) {
                    // Create admin user
                    $password_hash = password_hash('admin#778855', PASSWORD_DEFAULT);
                    
                    // Check if role_id 1 exists
                    $role_stmt = $mysqli1->prepare("SELECT role_id FROM users_roles WHERE role_id = 1");
                    $role_stmt->execute();
                    $role_exists = $role_stmt->get_result()->num_rows > 0;
                    $role_stmt->close();
                    
                    $role_id = $role_exists ? 1 : 1; // Default to 1
                    $role_name = $role_exists ? 'admin' : 'admin';
                    
                    $insert = $mysqli1->prepare("
                        INSERT INTO committee_users 
                        (username, password_hash, name, can_view_all, college_id, role_id, role_name, created_at)
                        VALUES ('admin', ?, 'Administrator', 1, NULL, ?, ?, NOW())
                    ");
                    $insert->bind_param("sis", $password_hash, $role_id, $role_name);
                    
                    if ($insert->execute()) {
                        echo '<div class="card success"><h3><i class="fas fa-check-circle me-2"></i>تم إنشاء مستخدم المسؤول بنجاح!</h3>';
                        echo '<p>معرف المستخدم الجديد: ' . $insert->insert_id . '</p>';
                        echo '<p>اسم المستخدم: admin</p>';
                        echo '<p>كلمة المرور: admin#778855</p>';
                        echo '<p>can_view_all: 1 (مفعل)</p></div>';
                        
                        // Refresh page to show updated info
                        echo '<script>setTimeout(function() { window.location.reload(); }, 2000);</script>';
                    } else {
                        echo '<div class="card error"><h3><i class="fas fa-times-circle me-2"></i>فشل إنشاء مستخدم المسؤول</h3>';
                        echo '<p>الخطأ: ' . $insert->error . '</p></div>';
                    }
                    $insert->close();
                }
                
                if (isset($_POST['fix_permissions'])) {
                    // Fix admin permissions
                    $update = $mysqli1->prepare("UPDATE committee_users SET can_view_all = 1 WHERE username = 'admin'");
                    
                    if ($update->execute()) {
                        $affected = $update->affected_rows;
                        echo '<div class="card success"><h3><i class="fas fa-check-circle me-2"></i>تم إصلاح الصلاحيات بنجاح!</h3>';
                        echo '<p>تم تحديث ' . $affected . ' سجل</p>';
                        echo '<p>تم تعيين can_view_all = 1 لمستخدم المسؤول</p></div>';
                        
                        // Refresh page to show updated info
                        echo '<script>setTimeout(function() { window.location.reload(); }, 2000);</script>';
                    } else {
                        echo '<div class="card error"><h3><i class="fas fa-times-circle me-2"></i>فشل إصلاح الصلاحيات</h3>';
                        echo '<p>الخطأ: ' . $update->error . '</p></div>';
                    }
                    $update->close();
                }
            }
            
        } catch (Exception $e) {
            echo '<div class="card error">';
            echo '<h3><i class="fas fa-times-circle me-2"></i>خطأ في قاعدة البيانات</h3>';
            echo '<p>' . e($e->getMessage()) . '</p>';
            echo '</div>';
        }
        ?>
        
        <div class="card">
            <h3>اختبارات إضافية</h3>
            
            <div class="test-section">
                <h4>1. اختبار صفحة التحكم بالمستخدمين</h4>
                <a href="user_control.php" class="btn btn-primary" target="_blank">
                    <i class="fas fa-users-cog me-2"></i>فتح صفحة التحكم بالمستخدمين
                </a>
            </div>
            
            <div class="test-section">
                <h4>2. اختبار تسجيل الدخول في نافذة جديدة</h4>
                <button onclick="window.open('login.php', '_blank')" class="btn btn-info">
                    <i class="fas fa-external-link-alt me-2"></i>فتح صفحة تسجيل الدخول
                </button>
            </div>
            
            <div class="test-section">
                <h4>3. اختبار مباشر لصلاحيات المسؤول</h4>
                <?php
                // Direct test of admin permissions
                if ($admin && $admin['can_view_all'] == 1) {
                    echo '<p class="success"><i class="fas fa-check-circle me-2"></i>صلاحيات المسؤول صحيحة في قاعدة البيانات</p>';
                    
                    // Test the boolean conversion
                    $test_value = $admin['can_view_all'];
                    $bool_test = (bool)$test_value;
                    echo '<p>اختبار التحويل البوليني: (bool)' . $test_value . ' = ' . ($bool_test ? 'TRUE' : 'FALSE') . '</p>';
                    
                    // Test comparison
                    echo '<p>اختبار المقارنة: ' . $test_value . ' == 1 → ' . ($test_value == 1 ? 'TRUE' : 'FALSE') . '</p>';
                    echo '<p>اختبار المقارنة الدقيقة: ' . $test_value . ' === 1 → ' . ($test_value === 1 ? 'TRUE' : 'FALSE') . '</p>';
                } else {
                    echo '<p class="error"><i class="fas fa-times-circle me-2"></i>صلاحيات المسؤول غير صحيحة في قاعدة البيانات</p>';
                }
                ?>
            </div>
        </div>
        
        <div class="card">
            <h3>روابط سريعة</h3>
            <div style="display: flex; flex-wrap: wrap; gap: 10px;">
                <a href="committee_dashboard.php" class="btn">
                    <i class="fas fa-tachometer-alt me-2"></i>لوحة التحكم
                </a>
                <a href="login.php" class="btn">
                    <i class="fas fa-sign-in-alt me-2"></i>صفحة تسجيل الدخول
                </a>
                <a href="logout.php" class="btn btn-danger">
                    <i class="fas fa-sign-out-alt me-2"></i>تسجيل الخروج
                </a>
            </div>
        </div>
    </div>
    
    <script>
        // Auto-refresh if we just created/fixed admin
        if (window.location.search.includes('refresh=1')) {
            setTimeout(function() {
                window.location.reload();
            }, 1000);
        }
    </script>
</body>
</html>