<?php
// check_student_id.php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require 'db.php';
require 'helpers.php';

// التحقق من الطلب POST فقط
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('HTTP/1.1 405 Method Not Allowed');
    exit();
}

// التحقق من CSRF token
if (!isset($_POST['csrf_token']) || !validate_csrf_token($_POST['csrf_token'])) {
    header('HTTP/1.1 403 Forbidden');
    echo json_encode(['error' => 'رمز الحماية غير صالح']);
    exit();
}

// التحقق من وجود رقم الطالب
if (!isset($_POST['student_id']) || empty(trim($_POST['student_id']))) {
    echo json_encode(['exists' => false]);
    exit();
}

$studentId = trim($_POST['student_id']);

// التحقق من وجود رقم الطالب في قاعدة البيانات
$checkStmt = $mysqli1->prepare("SELECT id FROM students WHERE student_id = ? AND deleted_at IS NULL");
$checkStmt->bind_param('s', $studentId);
$checkStmt->execute();
$checkStmt->store_result();

$exists = $checkStmt->num_rows > 0;
$checkStmt->close();

// إرجاع النتيجة كـ JSON
header('Content-Type: application/json');
echo json_encode(['exists' => $exists]);