<?php
// generate_student_id.php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header('Content-Type: application/json; charset=utf-8');

// السماح للجميع بالوصول
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

require 'db.php';
require 'helpers.php';

// تسجيل بدء الطلب
error_log("=== بدء توليد رقم الطالب ===");

try {
    // تسجيل البيانات الواردة
    error_log("📥 البيانات الواردة: " . print_r($_POST, true));
    
    // التحقق من طريقة الطلب
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        exit(0);
    }
    
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        error_log("❌ خطأ: طريقة الطلب ليست POST");
        echo json_encode([
            'success' => false, 
            'message' => 'طريقة الطلب غير مسموحة'
        ]);
        exit;
    }

    // جلب البيانات من POST
    $section_id = isset($_POST['section_id']) ? (int)$_POST['section_id'] : 0;
    $batch_id = isset($_POST['batch_id']) ? (int)$_POST['batch_id'] : 0;

    // التحقق من البيانات المطلوبة
    if (!$section_id || !$batch_id) {
        error_log("❌ خطأ: بيانات ناقصة");
        echo json_encode([
            'success' => false, 
            'message' => 'معرف القسم والدفعة مطلوب'
        ]);
        exit;
    }

    // البحث عن أكبر رقم طالب في نفس القسم والدفعة
    $query = "SELECT MAX(student_id) as max_student_id FROM students WHERE section_id = ? AND batch_id = ? AND deleted_at IS NULL";
    
    $stmt = $mysqli1->prepare($query);
    if (!$stmt) {
        $error = $mysqli1->error;
        error_log("❌ خطأ في إعداد الاستعلام: $error");
        throw new Exception("خطأ في استعلام قاعدة البيانات");
    }
    
    $stmt->bind_param('ii', $section_id, $batch_id);
    
    if (!$stmt->execute()) {
        $error = $stmt->error;
        error_log("❌ خطأ في تنفيذ الاستعلام: $error");
        throw new Exception("خطأ في تنفيذ الاستعلام");
    }
    
    $result = $stmt->get_result();
    $data = $result->fetch_assoc();
    $stmt->close();
    
    $max_student_id = $data['max_student_id'] ?? null;
    error_log("📊 أكبر رقم طالب موجود: " . ($max_student_id ?: 'لا يوجد'));
    
    $next_student_id = '';
    $details = '';
    
    if ($max_student_id && !empty($max_student_id)) {
        error_log("🔢 معالجة الرقم: $max_student_id");
        
        // استخراج الأرقام من الرقم
        preg_match_all('/\d+/', $max_student_id, $matches);
        
        if (!empty($matches[0])) {
            // أخذ آخر مجموعة أرقام
            $last_number = end($matches[0]);
            error_log("📊 الرقم المستخرج: $last_number");
            
            // تحويل إلى عدد وإضافة 1
            $next_number = (int)$last_number + 1;
            error_log("➕ الحساب: $last_number + 1 = $next_number");
            
            // الحفاظ على نفس التنسيق
            if (preg_match('/^([A-Za-z]+)/', $max_student_id, $letter_matches)) {
                $prefix = $letter_matches[1];
                $next_student_id = $prefix . $next_number;
                error_log("🧩 النتيجة: $prefix + $next_number = $next_student_id");
            } else {
                $next_student_id = (string)$next_number;
                error_log("🧩 النتيجة (بدون حروف): $next_student_id");
            }
            
            $details = "تم زيادة الرقم من {$max_student_id} إلى {$next_student_id}";
        } else {
            // إذا لم نجد أرقاماً، نبدأ من 1
            $next_student_id = '1';
            $details = "بدءاً من الرقم 1";
            error_log("⚠️ لا أرقام، البدء من: $next_student_id");
        }
    } else {
        // إذا لم يكن هناك طلاب سابقين، نبدأ بـ 1
        $next_student_id = '1';
        $details = "أول طالب في هذا القسم والدفعة";
        error_log("✅ أول طالب: $next_student_id");
    }
    
    // التحقق من عدم تكرار الرقم
    $check_query = "SELECT COUNT(*) as count FROM students WHERE student_id = ? AND deleted_at IS NULL";
    $check_stmt = $mysqli1->prepare($check_query);
    $check_stmt->bind_param('s', $next_student_id);
    $check_stmt->execute();
    $check_result = $check_stmt->get_result();
    $check_data = $check_result->fetch_assoc();
    $check_stmt->close();
    
    if ($check_data['count'] > 0) {
        error_log("⚠️ الرقم موجود مسبقاً، البحث عن رقم متاح");
        
        // البحث عن رقم متاح
        $counter = 1;
        $max_attempts = 100;
        
        while ($counter < $max_attempts) {
            $candidate_id = '';
            
            if (preg_match('/^([A-Za-z]*)(\d+)$/', $next_student_id, $matches)) {
                $prefix = $matches[1];
                $number = (int)$matches[2] + $counter;
                $candidate_id = $prefix . $number;
            } else {
                $candidate_id = ((int)$next_student_id + $counter);
            }
            
            $check_stmt = $mysqli1->prepare($check_query);
            $check_stmt->bind_param('s', $candidate_id);
            $check_stmt->execute();
            $check_result = $check_stmt->get_result();
            $check_data = $check_result->fetch_assoc();
            $check_stmt->close();
            
            if ($check_data['count'] == 0) {
                $next_student_id = $candidate_id;
                $details = "تم تعديل الرقم لتجنب التكرار إلى {$next_student_id}";
                error_log("✅ وجد رقم متاح: $next_student_id");
                break;
            }
            
            $counter++;
        }
    }
    
    error_log("🎉 تم توليد الرقم بنجاح: $next_student_id");
    
    // إرجاع النتيجة
    echo json_encode([
        'success' => true,
        'message' => 'تم توليد رقم الطالب بنجاح',
        'next_student_id' => $next_student_id,
        'last_student_id' => $max_student_id,
        'details' => $details
    ]);
    
} catch (Exception $e) {
    // في حالة حدوث خطأ
    $error_msg = "❌ خطأ غير متوقع: " . $e->getMessage();
    error_log($error_msg);
    
    echo json_encode([
        'success' => false, 
        'message' => 'حدث خطأ: ' . $e->getMessage()
    ]);
}

error_log("=== انتهاء توليد رقم الطالب ===\n");
?>