<?php if (session_status() === PHP_SESSION_NONE) session_start(); ?>
<!doctype html>
<html lang="en" dir="ltr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Admissions</title>

  <!-- Fonts & Bootstrap -->
 
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">


<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700;800&display=swap" rel="stylesheet">
<style>
  html[dir="rtl"], .rtl, .card-arabic, .rtl-heading {
    font-family: 'Cairo', system-ui, -apple-system, sans-serif !important;
  }
</style>

  <style>
    :root{
      --brand-green:#0a7d42;
      --brand-dark:#084b27;
      --soft-shadow:0 8px 24px rgba(0,0,0,.08);
    }
    body{ background:#f7f9fc; font-family:'Amiri', serif; }
    .card{ border:0; box-shadow:var(--soft-shadow); }
    .form-floating>.form-control:focus{
      border-color:#0d6efd;
      box-shadow:0 0 0 .2rem rgba(13,110,253,.15);
    }

    /* ===== Header ===== */
    .top-accent{ height:6px; background:linear-gradient(90deg, var(--brand-green), #14b36f, #42c98d); }
    .brand-bar{ background:#f7f9fc ; box-shadow:0 2px 12px rgba(0,0,0,.06); }

    /* key change: shrink-to-content grid centered */
    .brand-wrap{
      display:inline-grid;                /* shrink to content */
      grid-template-columns: 72px auto 72px; /* logos closer to center */
      align-items:center;
      gap:.75rem;                         /* tighter gap */
      margin-inline:auto;                 /* center the whole cluster */
      text-align:center;
    }
    .brand-logo{
      width:72px;height:72px;border-radius:50%;
      object-fit:cover;background:#f7f9fc ;
      border:2px solid rgba(0,0,0,.06);
      box-shadow:0 4px 12px rgba(0,0,0,.06);
    }
    .brand-title{ line-height:1.25; }
    .brand-title .en{
      color:var(--brand-dark);
      font-weight:700;
      letter-spacing:.2px;
      font-size:1.25rem;                  /* bigger */
    }
    .brand-title .ar{
      color:var(--brand-green);
      font-weight:700;
      font-size:1.2rem;                   /* bigger */
    }
    .brand-title .uni{
      color:#2b7a4b; font-weight:700; font-size:1.3rem; /* highlight line */
    }

    .meta-bar{ background:#f7f9fc ; border-top:1px solid #eef1f5; }

    /* Responsive tweaks */
    @media (min-width: 992px){
      .brand-wrap{ gap:1rem; grid-template-columns: 80px auto 80px; }
      .brand-logo{ width:80px;height:80px; }
      .brand-title .en{ font-size:1.35rem; }
      .brand-title .ar{ font-size:1.3rem; }
      .brand-title .uni{ font-size:1.45rem; }
    }
    @media (max-width: 576px){
      .brand-wrap{ grid-template-columns: 56px auto 56px; gap:.5rem; }
      .brand-logo{ width:56px;height:56px; }
      .brand-title .en{ font-size:1.1rem; }
      .brand-title .ar{ font-size:1.05rem; }
      .brand-title .uni{ font-size:1.15rem; }
    }

    /* RTL helper class for page body */
    .rtl{ direction:rtl; }
  </style>
</head>
<body>

<!-- Accent line -->
<div class="top-accent"></div>

<!-- Main Header -->
 <!-- Main Header -->
 <nav class="navbar brand-bar py-3">
  <div class="container text-center">
    <div class="brand-wrap" style="display: block; text-align: center;">
      <div style="font-family: 'Cairo', sans-serif; text-align: center; line-height: 1.2;">
        <div style="color: #1e0138; font-size: 1.8rem; font-weight: 600; margin-bottom: 5px;">Republic of Sudan</div>
        <div style="color: #1e0138; font-size: 1.4rem; margin-bottom: 8px;">Ministry of Higher Education & Scientific Research</div>
        <div style="color: #702804; font-size: 2.2rem; font-weight: 700; margin: 12px 0;">University of Gezira — Admissions</div>
        <div style="color: #702804; font-size: 2rem; font-weight: 600; direction: rtl; margin-top: 12px;">نظام التسجيل والقبول المركزي</div>
      </div>
    </div>
  </div>
</nav>

<!-- Meta / actions bar -->
 <!-- Enhanced Meta / Actions Bar -->
<div class="meta-bar py-2" style="background: var(--g-100); border-top: 1px solid var(--g-300); border-bottom: 1px solid var(--g-300);" dir="rtl">
  <div class="container d-flex flex-wrap align-items-center gap-2" style="font-family: 'Cairo', system-ui, -apple-system, sans-serif;">
    
    <!-- Home link with icon -->
    <a href="/Registration" class="btn btn-outline-primary btn-sm d-flex align-items-center gap-1">
      <i class="fas fa-home"></i>
      <span>الرئيسية</span>
    </a>

    <!-- Role-based quick actions -->
    <div class="d-flex gap-1 flex-wrap">
      <!-- Committee Login -->
      <a href="#" class="btn btn-outline-info btn-sm d-flex align-items-center gap-1">
        <i class="fas fa-user-tie"></i>
        <span>لجنة المعاينات</span>
      </a>
      
      <!-- Student Login -->
      <a href="#" class="btn btn-outline-success btn-sm d-flex align-items-center gap-1">
        <i class="fas fa-user-graduate"></i>
        <span>بوابة الطالب</span>
      </a>
      
      <!-- Medical Unit -->
      <a href="#" class="btn btn-outline-warning btn-sm d-flex align-items-center gap-1">
        <i class="fas fa-user-md"></i>
        <span>الوحدة الصحية</span>
      </a>
      
      <!-- Card Printing -->
      <a href="#" class="btn btn-outline-secondary btn-sm d-flex align-items-center gap-1">
        <i class="fas fa-print"></i>
        <span>طباعة البطاقات</span>
      </a>
      
      <!-- Accountant -->
      <a href="#" class="btn btn-outline-dark btn-sm d-flex align-items-center gap-1">
        <i class="fas fa-calculator"></i>
        <span>المحاسب</span>
      </a>
    </div>

    <!-- User status chip with enhanced styling -->
    <?php if (!empty($_SESSION['student_id'])): ?>
      <span class="badge text-bg-light border d-none d-sm-inline-flex align-items-center" style="background: var(--g-100) !important; border-color: var(--g-300) !important;">
        <span class="me-1">🎓</span>
        <span style="color: var(--g-900); font-weight: 600;">الطالب:</span>
        <strong class="ms-1" style="color: var(--g-700);"><?= htmlspecialchars($_SESSION['student_id']) ?></strong>
      </span>
    <?php elseif (!empty($_SESSION['committee_id'])): ?>
      <span class="badge text-bg-light border d-none d-sm-inline-flex align-items-center" style="background: var(--g-100) !important; border-color: var(--g-300) !important;">
        <span class="me-1">👨‍⚖️</span>
        <span style="color: var(--g-900); font-weight: 600;">مسجل الكلية:</span>
        <strong class="ms-1" style="color: var(--g-700);"><?= htmlspecialchars($_SESSION['committee_name'] ?? $_SESSION['committee_id']) ?></strong>
      </span>
    <?php elseif (!empty($_SESSION['admin_logged_in'])): ?>
      <span class="badge text-bg-light border d-none d-sm-inline-flex align-items-center" style="background: linear-gradient(135deg, #8e44ad, #9b59b6) !important; color: white !important;">
        <span class="me-1">👨‍💼</span>
        <span style="font-weight: 600;">الإدارة العليا:</span>
        <strong class="ms-1"><?= htmlspecialchars($_SESSION['admin_username'] ?? 'مدير النظام') ?></strong>
      </span>
    <?php endif; ?>

    <!-- Right side controls -->
    <div class="ms-auto d-flex gap-2 align-items-center">
      <!-- RTL/LTR Toggle -->
      <button id="rtlToggle" class="btn btn-outline-secondary btn-sm d-none d-sm-inline-flex align-items-center gap-1">
        <i class="fas fa-text-width"></i>
        <span>RTL/LTR</span>
      </button>
      
      <!-- Logout button (conditional) -->
      <?php if (!empty($_SESSION['student_id'])): ?>
        <a href="student_logout.php" class="btn btn-outline-danger btn-sm d-flex align-items-center gap-1">
          <i class="fas fa-sign-out-alt"></i>
          <span>تسجيل الخروج</span>
        </a>
      <?php elseif (!empty($_SESSION['committee_id'])): ?>
        <a href="committee_logout.php" class="btn btn-outline-danger btn-sm d-flex align-items-center gap-1">
          <i class="fas fa-sign-out-alt"></i>
          <span>تسجيل الخروج</span>
        </a>
      <?php elseif (!empty($_SESSION['admin_logged_in'])): ?>
        <a href="admin_logout.php" class="btn btn-outline-danger btn-sm d-flex align-items-center gap-1">
          <i class="fas fa-sign-out-alt"></i>
          <span>تسجيل الخروج</span>
        </a>
      <?php endif; ?>
      
      <!-- Current date display -->
      <span class="text-muted small d-none d-md-inline" style="color: var(--gray-600) !important;">
        <i class="fas fa-calendar me-1"></i>
        <?= date('Y-m-d') ?>
      </span>
    </div>

  </div>
</div>

<!-- Enhanced RTL Toggle Script -->
<script>
  document.addEventListener('DOMContentLoaded', () => {
    const html = document.documentElement;
    const body = document.body;
    const btn  = document.getElementById('rtlToggle');

    // Load saved direction or default to 'rtl' for Arabic
    const saved = localStorage.getItem('dirMode') || 'rtl';
    html.setAttribute('dir', saved);
    body.classList.toggle('rtl', saved === 'rtl');

    // Update button text based on current direction
    const updateButtonText = () => {
      if (btn) {
        const isRTL = html.getAttribute('dir') === 'rtl';
        btn.innerHTML = `<i class="fas fa-text-width"></i><span>${isRTL ? 'LTR' : 'RTL'}</span>`;
      }
    };

    // Initialize button text
    updateButtonText();

    // Toggle direction on button click
    btn?.addEventListener('click', () => {
      const now = html.getAttribute('dir') === 'rtl' ? 'ltr' : 'rtl';
      html.setAttribute('dir', now);
      body.classList.toggle('rtl', now === 'rtl');
      localStorage.setItem('dirMode', now);
      updateButtonText();
    });
  });
</script>

<!-- Page Content -->
<div class="container py-4">

<!-- RTL Toggle Script (with persistence) -->
<script>
  document.addEventListener('DOMContentLoaded', () => {
    const html = document.documentElement;
    const body = document.body;
    const btn  = document.getElementById('rtlToggle');

    const saved = localStorage.getItem('dirMode') || 'ltr';
    html.setAttribute('dir', saved);
    body.classList.toggle('rtl', saved === 'rtl');

    btn?.addEventListener('click', () => {
      const now = html.getAttribute('dir') === 'rtl' ? 'ltr' : 'rtl';
      html.setAttribute('dir', now);
      body.classList.toggle('rtl', now === 'rtl');
      localStorage.setItem('dirMode', now);
    });
  });
</script>
