<?php include 'header.php'; ?>
<!-- Cairo for Arabic -->
<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
  :root {
    /* نظام ألوان جامعة الجزيرة */
    --primary-dark: #003366;
    --primary: #0056B3;
    --primary-light: #1E88E5;
    --secondary: #FF6600;
    --secondary-light: #FF9900;
    --accent-blue: #1976D2;
    --accent-green: #2E7D32;
    --accent-red: #C62828;
    --accent-purple: #6A1B9A;
    --light-bg: #F8F9FA;
    --card-bg: #FFFFFF;
    --text-primary: #1A237E;
    --text-secondary: #546E7A;
    --border-light: #E0E0E0;
    --shadow-sm: 0 2px 8px rgba(0, 0, 0, 0.06);
    --shadow-md: 0 4px 12px rgba(0, 0, 0, 0.08);
    --shadow-lg: 0 8px 24px rgba(0, 0, 0, 0.12);
    --transition: all 0.3s ease;
  }

  body, h1, h2, h3, h4, h5, h6, p, a, button, label {
    font-family: 'Cairo', -apple-system, BlinkMacSystemFont, sans-serif;
  }

  body {
    background: linear-gradient(135deg, #f5f7fa 0%, #e3e9f7 100%);
    min-height: 100vh;
    position: relative;
  }

  /* خلفية أنيقة */
  .bg-pattern {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: 
      radial-gradient(circle at 10% 20%, rgba(0, 86, 179, 0.03) 0%, transparent 40%),
      radial-gradient(circle at 90% 80%, rgba(255, 102, 0, 0.03) 0%, transparent 40%);
    z-index: -1;
  }

  /* حاوية رئيسية */
  .main-wrapper {
    width: 85%;
    max-width: 1200px;
    margin: 0 auto;
    padding: 2rem 0;
  }

  /* بطاقة الأدوار - تصميم حديث وأنيق */
  .role-card {
    background: var(--card-bg);
    border-radius: 16px;
    padding: 2rem 1.5rem;
    border: 1px solid var(--border-light);
    box-shadow: var(--shadow-md);
    transition: var(--transition);
    text-align: center;
    position: relative;
    overflow: hidden;
    height: 100%;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: space-between;
  }

  .role-card:hover {
    transform: translateY(-6px);
    box-shadow: var(--shadow-lg);
    border-color: var(--primary-light);
  }

  /* شريط لوني علوي */
  .role-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 4px;
    background: linear-gradient(90deg, var(--primary), var(--primary-light));
  }

  /* أيقونة البطاقة */
  .card-icon-wrapper {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    background: linear-gradient(135deg, var(--primary), var(--primary-light));
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 1.5rem;
    box-shadow: 0 6px 12px rgba(0, 86, 179, 0.15);
  }

  .card-icon {
    font-size: 2rem;
    color: white;
    transition: var(--transition);
  }

  .role-card:hover .card-icon {
    transform: scale(1.1);
  }

  /* عنوان البطاقة */
  .card-title {
    font-size: 1.3rem;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 0.8rem;
    line-height: 1.4;
  }

  /* وصف البطاقة */
  .card-desc {
    color: var(--text-secondary);
    font-size: 0.95rem;
    line-height: 1.5;
    margin-bottom: 1.5rem;
    flex-grow: 1;
  }

  /* أزرار أنيقة ومتوسطة الحجم */
  .elegant-btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 0.75rem 1.5rem;
    border-radius: 10px;
    font-weight: 600;
    font-size: 0.95rem;
    text-decoration: none;
    transition: var(--transition);
    border: none;
    width: 100%;
    max-width: 200px;
    position: relative;
    overflow: hidden;
  }

  /* تأثير زر الإدارة العليا */
  .btn-admin {
    background: linear-gradient(135deg, var(--accent-purple), #8E24AA);
    color: white !important;
    border: 1px solid transparent;
  }

  .btn-admin:hover {
    background: linear-gradient(135deg, #8E24AA, var(--accent-purple));
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(106, 27, 154, 0.2);
  }

  /* تأثير زر الكليات */
  .btn-college {
    background: linear-gradient(135deg, var(--accent-green), #43A047);
    color: white !important;
    border: 1px solid transparent;
  }

  .btn-college:hover {
    background: linear-gradient(135deg, #43A047, var(--accent-green));
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(46, 125, 50, 0.2);
  }

  /* تأثير زر الوحدة الصحية */
  .btn-health {
    background: linear-gradient(135deg, var(--accent-red), #E53935);
    color: white !important;
    border: 1px solid transparent;
  }

  .btn-health:hover {
    background: linear-gradient(135deg, #E53935, var(--accent-red));
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(198, 40, 40, 0.2);
  }

  /* تأثير زر القبول والتسجيل */
  .btn-admission {
    background: linear-gradient(135deg, var(--accent-blue), #2196F3);
    color: white !important;
    border: 1px solid transparent;
  }

  .btn-admission:hover {
    background: linear-gradient(135deg, #2196F3, var(--accent-blue));
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(25, 118, 210, 0.2);
  }

  /* العنوان الرئيسي */
  .page-header {
    text-align: center;
    margin-bottom: 3rem;
  }

  .main-title {
    font-size: 2.5rem;
    font-weight: 800;
    color: var(--primary-dark);
    margin-bottom: 0.5rem;
    position: relative;
    display: inline-block;
  }

  .main-title::after {
    content: '';
    position: absolute;
    bottom: -10px;
    left: 50%;
    transform: translateX(-50%);
    width: 100px;
    height: 4px;
    background: linear-gradient(90deg, var(--primary), var(--secondary));
    border-radius: 2px;
  }

  .subtitle {
    color: var(--text-secondary);
    font-size: 1.1rem;
    margin-top: 1.5rem;
  }

  /* شبكة البطاقات */
  .cards-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 2rem;
    margin-bottom: 3rem;
  }

  /* بطاقة الشعار */
  .logo-card {
    background: var(--card-bg);
    border-radius: 16px;
    padding: 1.5rem;
    margin-bottom: 2rem;
    border: 1px solid var(--border-light);
    box-shadow: var(--shadow-sm);
    text-align: center;
  }

  .university-name {
    font-size: 1.8rem;
    color: var(--primary);
    font-weight: 700;
    margin-bottom: 0.5rem;
  }

  .system-name {
    color: var(--secondary);
    font-weight: 600;
    font-size: 1.1rem;
  }

  /* قسم المعلومات */
  .info-section {
    background: linear-gradient(135deg, rgba(0, 86, 179, 0.05), rgba(255, 102, 0, 0.05));
    border-radius: 16px;
    padding: 1.5rem;
    margin-top: 2rem;
    border: 1px solid rgba(0, 86, 179, 0.1);
  }

  .info-title {
    color: var(--primary);
    font-weight: 600;
    margin-bottom: 1rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
  }

  .info-text {
    color: var(--text-secondary);
    font-size: 0.95rem;
    line-height: 1.6;
  }

  /* تصميم متجاوب */
  @media (max-width: 1200px) {
    .main-wrapper {
      width: 90%;
    }
  }

  @media (max-width: 768px) {
    .main-wrapper {
      width: 95%;
    }
    
    .cards-grid {
      grid-template-columns: 1fr;
      gap: 1.5rem;
    }
    
    .main-title {
      font-size: 2rem;
    }
    
    .role-card {
      padding: 1.5rem 1rem;
    }
    
    .card-icon-wrapper {
      width: 70px;
      height: 70px;
    }
    
    .card-icon {
      font-size: 1.8rem;
    }
  }

  @media (max-width: 480px) {
    .main-title {
      font-size: 1.8rem;
    }
    
    .elegant-btn {
      padding: 0.65rem 1.2rem;
      font-size: 0.9rem;
    }
  }
</style>

<!-- Custom Font Style -->
<style>
  @font-face {
    font-family: 'AlJazeeraArabicBold';
    src: url('fonts/Al-Jazeera-Arabic-Bold.ttf') format('truetype');
    font-weight: bold;
    font-style: normal;
  }

  h1, h2, h3, h4, h5, h6 {
    font-family: 'AlJazeeraArabicBold', 'Cairo', sans-serif;
  }
</style>

<!-- خلفية -->
<div class="bg-pattern"></div>

<div class="container-fluid d-flex flex-column justify-content-center align-items-center py-4">

  <div class="main-wrapper">
    
    <!-- بطاقة الشعار والمعلومات -->
    <div class="logo-card">
      <h2 class="university-name">جامعة الجزيرة</h2>
      <p class="system-name">نظام القبول الإلكتروني الموحد</p>
      <p class="text-muted mt-2" style="font-size: 0.95rem;">
        بوابة الدخول الموحدة للنظام الإلكتروني للقبول والتسجيل
      </p>
    </div>

    <!-- العنوان الرئيسي -->
    <div class="page-header">
      <h1 class="main-title">النظام الإلكتروني للقبول</h1>
      <p class="subtitle">اختر الدور المناسب للدخول إلى النظام</p>
    </div>

    <!-- شبكة البطاقات -->
    <div class="cards-grid">
      
      <!-- الإدارة العليا -->
      <div class="role-card">
        <div class="card-icon-wrapper">
          <i class="fas fa-crown card-icon"></i>
        </div>
        <h3 class="card-title">الإدارة العليا</h3>
        <p class="card-desc">
          لوحة التحكم الرئيسية للإدارة العليا ومتابعة العمليات الإدارية والأكاديمية
        </p>
        <a href="admin_login.php" class="elegant-btn btn-admin">
          <i class="fas fa-sign-in-alt me-2"></i> دخول الإدارة
        </a>
      </div>
      
      <!-- الكليات والعمادات -->
      <div class="role-card">
        <div class="card-icon-wrapper" style="background: linear-gradient(135deg, var(--accent-green), #43A047);">
          <i class="fas fa-university card-icon"></i>
        </div>
        <h3 class="card-title">الكليات والعمادات</h3>
        <p class="card-desc">
          نظام إدارة الكليات والعمادات ومتابعة الطلبة والعمليات الأكاديمية
        </p>
        <a href="committee_login.php?role=committee" class="elegant-btn btn-college">
          <i class="fas fa-sign-in-alt me-2"></i> دخول الكليات
        </a>
      </div>
      
      <!-- الوحدة الصحية -->
      <div class="role-card">
        <div class="card-icon-wrapper" style="background: linear-gradient(135deg, var(--accent-red), #E53935);">
          <i class="fas fa-stethoscope card-icon"></i>
        </div>
        <h3 class="card-title">الوحدة الصحية</h3>
        <p class="card-desc">
          نظام الكشف الطبي والمتابعة الصحية وإدارة السجلات الطبية
        </p>
        <a href="doctor_login.php" class="elegant-btn btn-health">
          <i class="fas fa-sign-in-alt me-2"></i> دخول الوحدة
        </a>
      </div>
      
      <!-- القبول والتسجيل -->
      <div class="role-card">
        <div class="card-icon-wrapper" style="background: linear-gradient(135deg, var(--accent-blue), #2196F3);">
          <i class="fas fa-file-contract card-icon"></i>
        </div>
        <h3 class="card-title">القبول والتسجيل</h3>
        <p class="card-desc">
          نظام إدارة عمليات القبول والتسجيل والتنسيق والمتابعة الأكاديمية
        </p>
        <a href="admission_login.php" class="elegant-btn btn-admission">
          <i class="fas fa-sign-in-alt me-2"></i> دخول القبول
        </a>
      </div>

    </div>

    <!-- قسم المعلومات -->
    <div class="info-section">
      <h4 class="info-title">
        <i class="fas fa-info-circle"></i> معلومات هامة
      </h4>
      <p class="info-text">
        • يرجى استخدام حسابك الرسمي للدخول إلى النظام<br>
        • النظام متاح على مدار الساعة طوال أيام الأسبوع<br>
        • للحصول على المساعدة، يرجى التواصل مع الدعم الفني
      </p>
    </div>

  </div>

</div>

<?php include 'footer.php'; ?>