<?php
require 'db.php';
require 'helpers.php';
require_committee();

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !verify_csrf($_POST['csrf'] ?? '')) {
    http_response_code(400);
    exit('Bad request.');
}

$id = (int)($_POST['id'] ?? 0);
$decision = $_POST['decision'] ?? 'accept';
$notes = trim($_POST['notes'] ?? '');
$acceptance_rate = $_POST['acceptance_rate'] !== '' ? (string)$_POST['acceptance_rate'] : null;

$excluded = $decision === 'reject' ? 1 : 0;

$stmt = $mysqli1->prepare("UPDATE students SET excluded = ?, notes = ?, acceptance_rate = ? WHERE id = ?");
$stmt->bind_param("isdi", $excluded, $notes, $acceptance_rate, $id);
$stmt->execute();

header("Location: interview_review.php?id=$id&saved=1");
