<?php
// load_sections.php
require 'db.php';
require 'helpers.php';

header('Content-Type: application/json');

$college_id = $_GET['college_id'] ?? null;

if (!$college_id) {
    echo json_encode(['success' => false, 'message' => 'لم يتم تحديد الكلية']);
    exit;
}

$mysqli1->set_charset('utf8mb4');

$sections_sql = "
    SELECT DISTINCT s.id, s.name, s.parent
    FROM sections s 
    WHERE s.parent = ? AND s.deleted_at IS NULL 
    ORDER BY s.name
";

$sections_stmt = $mysqli1->prepare($sections_sql);
$sections_stmt->bind_param("i", $college_id);
$sections_stmt->execute();
$sections_result = $sections_stmt->get_result();
$sections = $sections_result->fetch_all(MYSQLI_ASSOC);
$sections_stmt->close();

echo json_encode([
    'success' => true,
    'sections' => $sections,
    'count' => count($sections)
]);
?>