<?php
session_start();
if (function_exists('opcache_reset')) { opcache_reset(); }
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Language handling
$lang = $_GET['lang'] ?? 'ar';
$isArabic = ($lang === 'ar');
$dir = $isArabic ? 'rtl' : 'ltr';

// DB Connection
$mysqli = new mysqli("uofg.edu.sd", "uofgedu_user8cer", "XI%ClX,e}R7oFkRSX", "uofgedu_registration");
$mysqli->set_charset("utf8mb4");

// Get medical records
$search = $_GET['search'] ?? '';
$query = "SELECT * FROM medical_records WHERE 1=1";

if (!empty($search)) {
    $query .= " AND (student_name LIKE '%$search%' OR student_phone LIKE '%$search%')";
}

$query .= " ORDER BY submitted_at DESC";
$records = $mysqli->query($query);
?>

<!DOCTYPE html>
<html lang="<?= $lang ?>" dir="<?= $dir ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= $isArabic ? 'السجلات الطبية - جامعة الجزيرة' : 'Medical Records - University of Gezira' ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        :root { --uofg-green: #006837; --uofg-dark-green: #004d26; }
        * { font-family: 'Cairo', sans-serif; }
        body { background: #f8f9fa; }
        
        .sidebar { background: var(--uofg-green); color: white; min-height: 100vh; }
        .sidebar .nav-link { color: white; padding: 1rem 1.5rem; margin: 0.25rem 0; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background: rgba(255,255,255,0.1); }
        
        .record-card {
            background: white;
            border-radius: 0.5rem;
            padding: 1.5rem;
            margin-bottom: 1rem;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            border-right: 4px solid var(--uofg-green);
        }
        
        .status-badge { padding: 0.5rem 1rem; border-radius: 1rem; font-weight: 600; }
        .badge-normal { background: #d4edda; color: #155724; }
        .badge-abnormal { background: #f8d7da; color: #721c24; }
    </style>
</head>
<body dir="<?= $dir ?>">
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <nav class="col-md-3 col-lg-2 d-md-block sidebar">
                <div class="position-sticky pt-3">
                    <div class="text-center mb-4">
                        <img src="https://uofg.edu.sd/wp-content/uploads/2023/08/cropped-UofG-Logo-1.png" height="50" class="mb-2">
                        <h6 class="fw-bold"><?= $isArabic ? 'نظام الإدارة' : 'Management System' ?></h6>
                    </div>
                    
                    <ul class="nav flex-column">
                        <li class="nav-item"><a class="nav-link" href="supervisor_dashboard.php?lang=<?= $lang ?>"><i class="bi bi-speedometer2"></i> <?= $isArabic ? 'لوحة التحكم' : 'Dashboard' ?></a></li>
                        <li class="nav-item"><a class="nav-link" href="supervisor_requests.php?lang=<?= $lang ?>"><i class="bi bi-journal-text"></i> <?= $isArabic ? 'إدارة الطلبات' : 'Requests' ?></a></li>
                        <li class="nav-item"><a class="nav-link" href="supervisor_payments.php?lang=<?= $lang ?>"><i class="bi bi-credit-card"></i> <?= $isArabic ? 'المدفوعات' : 'Payments' ?></a></li>
                        <li class="nav-item"><a class="nav-link active" href="medical_records.php?lang=<?= $lang ?>"><i class="bi bi-clipboard2-pulse"></i> <?= $isArabic ? 'السجلات الطبية' : 'Medical Records' ?></a></li>
                        <li class="nav-item"><a class="nav-link" href="medical_form.php?lang=<?= $lang ?>"><i class="bi bi-file-medical"></i> <?= $isArabic ? 'نموذج طبي' : 'Medical Form' ?></a></li>
                    </ul>
                    
                    <div class="mt-4 p-3">
                        <div class="d-grid gap-2">
                            <a href="?lang=ar" class="btn <?= $isArabic ? 'btn-light' : 'btn-outline-light' ?>">العربية</a>
                            <a href="?lang=en" class="btn <?= !$isArabic ? 'btn-light' : 'btn-outline-light' ?>">English</a>
                        </div>
                    </div>
                </div>
            </nav>

            <!-- Main Content -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2 class="fw-bold"><?= $isArabic ? 'السجلات الطبية' : 'Medical Records' ?></h2>
                    <div class="d-flex gap-2">
                        <form class="d-flex">
                            <input type="text" name="search" class="form-control" placeholder="<?= $isArabic ? 'بحث بالاسم أو الهاتف...' : 'Search by name or phone...' ?>" value="<?= htmlspecialchars($search) ?>">
                            <button class="btn btn-primary"><?= $isArabic ? 'بحث' : 'Search' ?></button>
                        </form>
                        <a href="medical_form.php?lang=<?= $lang ?>" class="btn btn-success">
                            <i class="bi bi-plus-circle"></i>
                            <?= $isArabic ? 'سجل طبي جديد' : 'New Medical Record' ?>
                        </a>
                    </div>
                </div>

                <!-- Records List -->
                <?php while($record = $records->fetch_assoc()): ?>
                <div class="record-card">
                    <div class="row">
                        <div class="col-md-8">
                            <h5 class="fw-bold"><?= htmlspecialchars($record['student_name']) ?></h5>
                            <div class="row">
                                <div class="col-md-6">
                                    <p><strong><?= $isArabic ? 'الهاتف:' : 'Phone:' ?></strong> <?= htmlspecialchars($record['student_phone']) ?></p>
                                    <p><strong><?= $isArabic ? 'البريد:' : 'Email:' ?></strong> <?= htmlspecialchars($record['student_email']) ?></p>
                                    <p><strong><?= $isArabic ? 'الحالة الصحية:' : 'Health Status:' ?></strong> 
                                        <span class="badge bg-<?= 
                                            $record['overall_health_status'] === 'excellent' ? 'success' : 
                                            ($record['overall_health_status'] === 'good' ? 'info' : 
                                            ($record['overall_health_status'] === 'fair' ? 'warning' : 'danger'))
                                        ?>">
                                            <?= $isArabic ? 
                                                ($record['overall_health_status'] === 'excellent' ? 'ممتاز' : 
                                                ($record['overall_health_status'] === 'good' ? 'جيد' : 
                                                ($record['overall_health_status'] === 'fair' ? 'متوسط' : 'ضعيف'))) :
                                                ucfirst($record['overall_health_status'])
                                            ?>
                                        </span>
                                    </p>
                                </div>
                                <div class="col-md-6">
                                    <p><strong><?= $isArabic ? 'تاريخ التسجيل:' : 'Registration Date:' ?></strong> <?= $record['submitted_at'] ?></p>
                                    <p><strong><?= $isArabic ? 'التطعيمات:' : 'Vaccinations:' ?></strong> 
                                        <span class="badge <?= $record['vaccinated'] === 'yes' ? 'bg-success' : 'bg-warning' ?>">
                                            <?= $isArabic ? 
                                                ($record['vaccinated'] === 'yes' ? 'مكتمل' : 'ناقص') :
                                                ($record['vaccinated'] === 'yes' ? 'Complete' : 'Incomplete')
                                            ?>
                                        </span>
                                    </p>
                                    <p><strong><?= $isArabic ? 'لقاح كوفيد:' : 'COVID Vaccine:' ?></strong> 
                                        <span class="badge <?= $record['covid_vaccine'] === 'yes' ? 'bg-success' : 'bg-warning' ?>">
                                            <?= $isArabic ? 
                                                ($record['covid_vaccine'] === 'yes' ? 'مكتمل' : 
                                                ($record['covid_vaccine'] === 'partially' ? 'جزئي' : 'ناقص')) :
                                                ucfirst($record['covid_vaccine'])
                                            ?>
                                        </span>
                                    </p>
                                </div>
                            </div>
                            
                            <?php if ($record['doctor_notes']): ?>
                            <div class="mt-3">
                                <strong><?= $isArabic ? 'ملاحظات الطبيب:' : 'Doctor Notes:' ?></strong>
                                <p class="mb-0"><?= htmlspecialchars($record['doctor_notes']) ?></p>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="col-md-4 text-start">
                            <div class="d-grid gap-2">
                                <button class="btn btn-primary" onclick="viewRecord(<?= $record['id'] ?>)">
                                    <i class="bi bi-eye"></i>
                                    <?= $isArabic ? 'عرض التفاصيل' : 'View Details' ?>
                                </button>
                                <button class="btn btn-info">
                                    <i class="bi bi-printer"></i>
                                    <?= $isArabic ? 'طباعة' : 'Print' ?>
                                </button>
                                <button class="btn btn-warning">
                                    <i class="bi bi-pencil"></i>
                                    <?= $isArabic ? 'تعديل' : 'Edit' ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endwhile; ?>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function viewRecord(id) {
            alert('<?= $isArabic ? "عرض السجل الطبي رقم: " : "Viewing medical record ID: " ?>' + id);
            // Implement modal or separate page for detailed view
        }
    </script>
</body>
</html>