<?php
// save_specialization.php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

require 'db.php';
require 'helpers.php';
require_committee();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: manage-specializations.php');
    exit;
}

// Get and validate input
$college_id = isset($_POST['college_id']) ? (int)$_POST['college_id'] : 0;
$section_id = isset($_POST['section_id']) ? (int)$_POST['section_id'] : 0;
$program_id = isset($_POST['program_id']) ? (int)$_POST['program_id'] : 0;
$specialization_name_ar = trim($_POST['specialization_name_ar'] ?? '');
$specialization_name_en = trim($_POST['specialization_name_en'] ?? '');
$degree_awarded_ar = trim($_POST['degree_awarded_ar'] ?? '');
$degree_awarded_en = trim($_POST['degree_awarded_en'] ?? '');

// Validate required fields
$errors = [];
if (!$college_id) $errors[] = 'الكلية مطلوبة';
if (!$section_id) $errors[] = 'القسم مطلوب';
if (!$program_id) $errors[] = 'البرنامج مطلوب';
if (empty($specialization_name_ar)) $errors[] = 'اسم التخصص بالعربية مطلوب';
if (empty($specialization_name_en)) $errors[] = 'اسم التخصص بالإنجليزية مطلوب';

// Check committee permissions
$committeeId = (int)($_SESSION['committee_id'] ?? 0);
$canAll = (bool)($_SESSION['committee_can_all'] ?? false);
$scopeCollege = isset($_SESSION['committee_college_id']) ? (int)$_SESSION['committee_college_id'] : null;

if (!$canAll && $scopeCollege !== null && $scopeCollege != $college_id) {
    $errors[] = 'لا تملك صلاحية إضافة تخصص لهذه الكلية';
}

if (!empty($errors)) {
    $_SESSION['error_message'] = implode(' - ', $errors);
    header('Location: manage-specializations.php');
    exit;
}

// Check if specialization already exists
$check_stmt = $mysqli1->prepare("
    SELECT specialization_id FROM specializations 
    WHERE college_id = ? AND section_id = ? AND program_id = ? 
    AND specialization_name_ar = ? AND deleted_at IS NULL
");
$check_stmt->bind_param("iiis", $college_id, $section_id, $program_id, $specialization_name_ar);
$check_stmt->execute();
$check_result = $check_stmt->get_result();

if ($check_result->num_rows > 0) {
    $_SESSION['error_message'] = 'هذا التخصص موجود مسبقاً';
    header('Location: manage-specializations.php');
    exit;
}

// Insert new specialization
$insert_stmt = $mysqli1->prepare("
    INSERT INTO specializations (
        college_id, section_id, program_id, 
        specialization_name_ar, specialization_name_en,
        degree_awarded_ar, degree_awarded_en,
        created_at, updated_at
    ) VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), NOW())
");

$insert_stmt->bind_param(
    "iiissss",
    $college_id, $section_id, $program_id,
    $specialization_name_ar, $specialization_name_en,
    $degree_awarded_ar, $degree_awarded_en
);

if ($insert_stmt->execute()) {
    $_SESSION['success_message'] = 'تم إضافة التخصص بنجاح';
} else {
    $_SESSION['error_message'] = 'حدث خطأ أثناء إضافة التخصص: ' . $mysqli1->error;
}

header('Location: manage-specializations.php');
exit;