<?php
// save_student.php - الإصدار المصحح بناءً على هيكل الجدول
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

require 'db.php';
require 'helpers.php';
require_committee();

try {
    // التحقق من أن الطلب POST
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('طريقة الطلب غير مسموحة');
    }

    // التحقق من أن اللجنة مسجلة دخولها
    if (!isset($_SESSION['committee_id'])) {
        throw new Exception('يجب تسجيل الدخول أولاً');
    }

    // جمع البيانات من النموذج
    $student_id = isset($_POST['student_id']) ? trim($_POST['student_id']) : '';
    $student_name = isset($_POST['student_name']) ? trim($_POST['student_name']) : '';
    $gender = isset($_POST['gender']) ? (int)$_POST['gender'] : 0;
    $college_id = isset($_POST['college_id']) ? trim($_POST['college_id']) : '';
    $program_id = isset($_POST['program_id']) ? trim($_POST['program_id']) : '';
    $section_id = isset($_POST['section_id']) ? trim($_POST['section_id']) : '';
    $batch_id = isset($_POST['batch_id']) ? trim($_POST['batch_id']) : '';
    
    // الحقول الاختيارية
    $admission_type_id = isset($_POST['admission_type_id']) ? (int)$_POST['admission_type_id'] : 0;
    $admission_id = ($admission_type_id > 0) ? (string)$admission_type_id : null;
    
    // الحقول المالية (تكون قيمها 0 افتراضياً)
    $program_fees = isset($_POST['program_fees']) ? (float)$_POST['program_fees'] : 0.00;
    $registration_fees = isset($_POST['registration_fees']) ? (float)$_POST['registration_fees'] : 0.00;
    $insurance_fees = isset($_POST['insurance_fees']) ? (float)$_POST['insurance_fees'] : 0.00;
    $discount = isset($_POST['discount']) ? (float)$_POST['discount'] : 0.00;
    
    // التحقق من صحة قيم enum للحقول
    $allowed_decision_statuses = ['pending', 'accepted', 'rejected'];
    $allowed_interview_statuses = ['pending', 'accepted', 'rejected'];
    $allowed_medically_fit = ['pending', 'completed', 'exempted'];
    
    // تعيين القيم مع التحقق من الصحة
    $decision_status = isset($_POST['decision_status']) ? $_POST['decision_status'] : 'pending';
    if (!in_array($decision_status, $allowed_decision_statuses)) {
        $decision_status = 'pending';
    }
    
    // interview_status قيمة ثابتة (ليس موجوداً في النموذج)
    $interview_status = 'pending';
    
    $profile_completed = isset($_POST['profile_completed']) ? (int)$_POST['profile_completed'] : 0;
    
    // حالة medically_fit من النموذج مع التحقق
    $medically_fit_input = isset($_POST['medically_fit']) ? $_POST['medically_fit'] : 'pending';
    if (!in_array($medically_fit_input, $allowed_medically_fit)) {
        $medically_fit_input = 'pending';
    }
    
    // تحويل medically_fit إلى tinyint بناءً على القيمة
    $medically_fit = null;
    if ($medically_fit_input === 'completed') {
        $medically_fit = 1;
    } elseif ($medically_fit_input === 'exempted') {
        $medically_fit = 0;
    }
    // إذا كانت 'pending' أو أي قيمة أخرى، تبقى null

    // التحقق من البيانات المطلوبة
    $required_fields = [
        'student_id' => $student_id,
        'student_name' => $student_name,
        'college_id' => $college_id,
        'program_id' => $program_id,
        'section_id' => $section_id,
        'batch_id' => $batch_id
    ];

    $missing_fields = [];
    foreach ($required_fields as $field => $value) {
        if (empty($value)) {
            $missing_fields[] = $field;
        }
    }

    if (!empty($missing_fields)) {
        throw new Exception('الحقول التالية مطلوبة: ' . implode(', ', $missing_fields));
    }

    // التحقق من صحة الجنس (0 للقيمة الافتراضية، 1 لذكر، 2 لأنثى)
    if (!in_array($gender, [0, 1, 2])) {
        $gender = 0;
    }

    // التحقق من عدم تكرار رقم الطالب
    $check_query = "SELECT COUNT(*) as count FROM students WHERE student_id = ? AND deleted_at IS NULL";
    $check_stmt = $mysqli1->prepare($check_query);
    $check_stmt->bind_param('s', $student_id);
    $check_stmt->execute();
    $check_result = $check_stmt->get_result();
    $check_data = $check_result->fetch_assoc();
    $check_stmt->close();

    if ($check_data['count'] > 0) {
        throw new Exception('رقم الطالب "' . $student_id . '" موجود مسبقاً في النظام');
    }

    // التحقق من أن الأرقام المالية غير سالبة
    if ($program_fees < 0) $program_fees = 0;
    if ($registration_fees < 0) $registration_fees = 0;
    if ($insurance_fees < 0) $insurance_fees = 0;
    if ($discount < 0) $discount = 0;
    if ($discount > 100) $discount = 100;

    // إعداد الاستعلام لإدخال الطالب - بناءً على هيكل الجدول
    $query = "INSERT INTO students (
                student_id, 
                student_number, 
                student_name, 
                gender, 
                program_fees, 
                registration_fees, 
                insurance_fees, 
                discount, 
                college_id, 
                program_id, 
                section_id, 
                admission_id, 
                batch_id, 
                excluded, 
                medically_fit, 
                decision_status, 
                interview_status, 
                interview_notes, 
                profile_completed, 
                self_declare_fit
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $mysqli1->prepare($query);
    if (!$stmt) {
        throw new Exception('خطأ في إعداد استعلام قاعدة البيانات: ' . $mysqli1->error);
    }

    // تعيين القيم الافتراضية للحقول غير الموجودة في النموذج
    $student_number = $student_id; // نفس student_id
    $excluded = 0; // قيمة افتراضية
    $interview_notes = null; // قيمة افتراضية
    $self_declare_fit = 0; // قيمة افتراضية

    // سلسلة الأنواع: يجب أن تحتوي على 20 حرفاً (لأن لدينا 20 علامة استفهام)
    // s = string, i = integer, d = double, b = blob
    // الترتيب: 20 متغيراً
    $types = 'sssiddddsssssisssssi';
    
    $stmt->bind_param(
        $types,
        $student_id,           // string
        $student_number,       // string
        $student_name,         // string
        $gender,               // integer (tinyint)
        $program_fees,         // double
        $registration_fees,    // double
        $insurance_fees,       // double
        $discount,             // double (float في PHP)
        $college_id,           // string
        $program_id,           // string
        $section_id,           // string
        $admission_id,         // string (أو null)
        $batch_id,             // string
        $excluded,             // integer (tinyint)
        $medically_fit,        // integer (tinyint) أو null
        $decision_status,      // string
        $interview_status,     // string
        $interview_notes,      // string (أو null)
        $profile_completed,    // integer (tinyint)
        $self_declare_fit      // integer (tinyint)
    );

    if (!$stmt->execute()) {
        error_log("خطأ MySQL: " . $stmt->error);
        error_log("رمز الخطأ: " . $stmt->errno);
        error_log("استعلام SQL: " . $query);
        
        throw new Exception('خطأ في حفظ بيانات الطالب: ' . $stmt->error);
    }

    $new_student_id = $mysqli1->insert_id;
    $stmt->close();

    // إعداد رسالة النجاح
    $_SESSION['success_message'] = "✅ تم إضافة الطالب {$student_name} بنجاح برقم: {$student_id}";

    // إعادة التوجيه إلى صفحة إضافة طالب جديدة
    header('Location: add-student.php');
    exit();

} catch (Exception $e) {
    // تخزين رسالة الخطأ في الجلسة
    $_SESSION['error_message'] = $e->getMessage();
    
    // حفظ البيانات في الجلسة لإعادة تعبئة النموذج
    $_SESSION['form_data'] = $_POST;
    
    // للحصول على تفاصيل أكثر للتصحيح
    error_log("حدث خطأ في save_student.php: " . $e->getMessage());
    error_log("Trace: " . $e->getTraceAsString());
    
    // إعادة التوجيه إلى صفحة إضافة طالب مع عرض الخطأ
    header('Location: add-student.php');
    exit();
}