<?php
require 'db.php';
require 'helpers.php';
require_student();

// Prevent browser caching
header("Expires: Tue, 01 Jan 2000 00:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

// Fetch student data (include ID + email for a better receipt)
$student_id = $_SESSION['student_id'];
$stmt = $mysqli1->prepare("
  SELECT student_id, student_name, phone_number, email
  FROM students
  WHERE student_id = ?
  LIMIT 1
");
$stmt->bind_param("s", $student_id);
$stmt->execute();
$data = $stmt->get_result()->fetch_assoc();

include 'header.php';
?>

 
<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700;800&family=Roboto:wght@400;700&display=swap" rel="stylesheet">


<style>
  :root{
    --brand-green:#198754;
    --brand-green-2:#27b06a;
    --brand-blue:#0d6efd;
    --ink:#1f2937;
    --muted:#6b7280;
    --card-bg:#ffffff;
    --bg:#f6f9fc;
    --ring: 0 10px 30px rgba(25,135,84,.15);
  }
  body{ background: var(--bg); font-family:'Roboto',sans-serif; }

  /* Hero */
  .hero {
    background: linear-gradient(135deg, #e9fff4 0%, #eef7ff 100%);
    border-radius: 18px;
    padding: 2.25rem;
    box-shadow: 0 10px 30px rgba(0,0,0,.06);
    border: 1px solid #e7f3ee;
  }
  .hero .badge-check {
    width: 84px; height: 84px; border-radius: 50%;
    display: grid; place-items: center;
    background: radial-gradient(closest-side, #2ec27e, #1faa66);
    color: #fff; font-size: 36px; font-weight: 700;
    box-shadow: var(--ring);
  }
  .hero h1 {
    margin: 0;
    font-size: 1.75rem;
    color: var(--ink);
    font-weight: 800;
    letter-spacing:.2px;
  }
  .hero p.lead {
    margin: .25rem 0 0;
    color: var(--muted);
  }

  /* Receipt card */
  .receipt {
    background: var(--card-bg);
    border: 1px solid #eef2f7;
    border-radius: 16px;
    box-shadow: 0 10px 25px rgba(0,0,0,.05);
    padding: 1.5rem;
  }
  .section-title {
    font-weight: 800;
    color: var(--ink);
    margin-bottom: .75rem;
  }
  .rtl {
    direction: rtl; text-align: right; font-family: 'AR One Sans', sans-serif;
  }
  .kv {
    display:grid; grid-template-columns: 180px 1fr; gap:.5rem 1rem;
  }
  .kv .k { color: var(--muted); }
  .divider {
    height:1px; background:#eef2f7; margin:1rem 0;
  }

  /* Next steps list */
  .steps li {
    display:flex; gap:.75rem; align-items:flex-start;
    padding:.5rem 0;
  }
  .steps .dot {
    width:28px;height:28px;border-radius:50%;
    background:#ecfdf5; color:#0f766e; display:grid;place-items:center;
    border:1px solid #d1fae5; font-weight:700;
  }
  .actions .btn {
    min-width: 160px;
  }
/* keep Roboto as default for EN/Latin */
body { font-family: 'Roboto', sans-serif; }

/* make all Arabic sections use Cairo */
.rtl,
.header-card,
.card-arabic {
  font-family: 'Cairo', 'AR One Sans', system-ui, -apple-system, sans-serif !important;
}

/* Arabic headings a bit bolder with Cairo */
.rtl h1, .rtl h2, .rtl h3, .rtl h4, .rtl h5, .rtl h6,
.header-text h4, .header-text h6,
.section-title {
  font-family: 'Cairo', sans-serif !important;
  font-weight: 700;
}

  /* Print style */
  @media print {
    nav, .actions { display:none !important; }
    .hero { box-shadow:none; border:0; }
    .receipt { box-shadow:none; border:1px solid #ccc; }
    body { background:#fff; }
  }
</style>

<div class="container my-4">

  <?php if ($data): ?>
    <!-- HERO -->
    <div class="hero mb-4">
      <div class="d-flex align-items-center gap-3 flex-wrap">
        <div class="badge-check">✓</div>
        <div class="flex-grow-1">
          <h1 class="rtl">تم إرسال الطلب بنجاح</h1>
          <p class="lead rtl">شكرًا لك <strong><?= e($data['student_name']) ?></strong>. تم حفظ بياناتك بنجاح وسيتم إشعارك بالتحديثات عبر الرسائل القصيرة والبريد الإلكتروني.</p>
        </div>
      </div>
    </div>

    <!-- RECEIPT (Arabic) -->
    <div class="receipt rtl mb-3">
      <div class="section-title">ملخص الطلب</div>
      <div class="kv">
        <div class="k">اسم الطالب</div><div><strong><?= e($data['student_name']) ?></strong></div>
        <div class="k">الرقم الجامعي</div><div><code><?= e($data['student_id']) ?></code></div>
        <div class="k">الهاتف</div><div><?= e($data['phone_number']) ?></div>
        <div class="k">البريد الإلكتروني</div><div><?= e($data['email'] ?? '—') ?></div>
      </div>

      <div class="divider"></div>

      <div class="section-title">الخطوات القادمة</div>
      <ul class="list-unstyled steps">
        <li><span class="dot">1</span> مراجعة لجنة القبول للبيانات والأوراق المرفقة.</li>
        <li><span class="dot">2</span> استلام رسالة SMS/Email بنتيجة المراجعة أو طلب استكمال بيانات.</li>
        <li><span class="dot">3</span> في حال القبول، سيتم إرسال تعليمات إكمال إجراءات التسجيل وسداد الرسوم.</li>
      </ul>
    </div>

    <!-- RECEIPT (English) -->
    <div class="receipt mb-4">
      <div class="section-title">Submission Receipt</div>
      <div class="kv">
        <div class="k">Student Name</div><div><strong><?= e($data['student_name']) ?></strong></div>
        <div class="k">Student ID</div><div><code><?= e($data['student_id']) ?></code></div>
        <div class="k">Mobile</div><div><?= e($data['phone_number']) ?></div>
        <div class="k">Email</div><div><?= e($data['email'] ?? '—') ?></div>
      </div>

      <div class="divider"></div>

      <div class="section-title">What happens next</div>
      <ul class="list-unstyled steps">
        <li><span class="dot">1</span> Admissions committee will review your profile & attachments.</li>
        <li><span class="dot">2</span> You’ll receive an SMS/Email with the decision or a request for more info.</li>
        <li><span class="dot">3</span> If accepted, you’ll get instructions to finalize enrollment and fees.</li>
      </ul>
    </div>

    <!-- ACTIONS -->
    <div class="actions d-flex flex-wrap gap-2">
      <a href="student_profile.php" class="btn btn-success">
        العودة للملف الشخصي
      </a>
      <a href="student_profile.php" class="btn btn-outline-success">
        تعديل البيانات
      </a>
      <button type="button" class="btn btn-outline-primary" onclick="window.print()">
        طباعة التقرير / Print report
      </button>
    </div>

  <?php else: ?>
    <div class="alert alert-danger text-center mt-5">
      ❌ No student data found. Please <a href="student_login.php" class="alert-link">log in</a> again.
    </div>
  <?php endif; ?>

</div>

<?php include 'footer.php'; ?>
