<?php
// test.php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>اختبار النظام</h1>";

// اختبار 1: ملف db.php
echo "<h3>اختبار 1: تحميل db.php</h3>";
if (file_exists('db.php')) {
    echo "✅ ملف db.php موجود<br>";
    require 'db.php';
    if (isset($mysqli1)) {
        echo "✅ متغير mysqli1 موجود<br>";
        if (!$mysqli1->connect_error) {
            echo "✅ الاتصال بقاعدة البيانات ناجح<br>";
        } else {
            echo "❌ فشل الاتصال: " . $mysqli1->connect_error . "<br>";
        }
    } else {
        echo "❌ متغير mysqli1 غير موجود في db.php<br>";
    }
} else {
    echo "❌ ملف db.php غير موجود في المسار: " . __DIR__ . "/db.php<br>";
}

// اختبار 2: ملف helpers.php
echo "<h3>اختبار 2: تحميل helpers.php</h3>";
if (file_exists('helpers.php')) {
    echo "✅ ملف helpers.php موجود<br>";
    require 'helpers.php';
    if (function_exists('e')) {
        echo "✅ دالة e موجودة<br>";
    } else {
        echo "❌ دالة e غير موجودة<br>";
    }
} else {
    echo "❌ ملف helpers.php غير موجود<br>";
}

// اختبار 3: الجلسة
echo "<h3>اختبار 3: الجلسة</h3>";
session_start();
$_SESSION['test'] = 'نعم';
echo "✅ تم بدء الجلسة<br>";
echo "قيمة test في الجلسة: " . ($_SESSION['test'] ?? 'غير موجودة') . "<br>";

// اختبار 4: استعلام بسيط
echo "<h3>اختبار 4: استعلام بسيط</h3>";
if (isset($mysqli1) && !$mysqli1->connect_error) {
    $result = $mysqli1->query("SELECT 1 as test");
    if ($result) {
        echo "✅ يمكن تنفيذ الاستعلامات بنجاح<br>";
    } else {
        echo "❌ فشل تنفيذ الاستعلام: " . $mysqli1->error . "<br>";
    }
}

// اختبار 5: مجلد ajax
echo "<h3>اختبار 5: مجلد ajax</h3>";
if (is_dir('ajax')) {
    echo "✅ مجلد ajax موجود<br>";
    $ajax_files = scandir('ajax');
    echo "الملفات: " . implode(', ', array_diff($ajax_files, ['.', '..'])) . "<br>";
} else {
    echo "❌ مجلد ajax غير موجود - سنقوم بإنشائه<br>";
    if (mkdir('ajax', 0755)) {
        echo "✅ تم إنشاء مجلد ajax بنجاح<br>";
    } else {
        echo "❌ فشل إنشاء مجلد ajax - تأكد من الصلاحيات<br>";
    }
}

// معلومات إضافية
echo "<h3>معلومات النظام:</h3>";
echo "PHP Version: " . phpversion() . "<br>";
echo "المسار الحالي: " . __DIR__ . "<br>";
echo "Server Software: " . ($_SERVER['SERVER_SOFTWARE'] ?? 'غير معروف') . "<br>";
?>